/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.table;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.exception.ConnectionUnavailableException;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.query.processor.stream.window.FindableProcessor;
import org.wso2.siddhi.core.table.CompiledUpdateSet;
import org.wso2.siddhi.core.util.ExceptionUtil;
import org.wso2.siddhi.core.util.collection.AddingStreamEventExtractor;
import org.wso2.siddhi.core.util.collection.operator.CompiledCondition;
import org.wso2.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.core.util.transport.BackoffRetryCounter;
import org.wso2.siddhi.query.api.definition.TableDefinition;
import org.wso2.siddhi.query.api.execution.query.output.stream.UpdateSet;

public abstract class Table
implements FindableProcessor {
    private static final Logger LOG = Logger.getLogger(Table.class);
    protected TableDefinition tableDefinition;
    private AtomicBoolean isTryingToConnect = new AtomicBoolean(false);
    private BackoffRetryCounter backoffRetryCounter = new BackoffRetryCounter();
    private AtomicBoolean isConnected = new AtomicBoolean(false);
    private ScheduledExecutorService scheduledExecutorService;
    private SiddhiAppContext siddhiAppContext;

    public void initTable(TableDefinition tableDefinition, StreamEventPool storeEventPool, StreamEventCloner storeEventCloner, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        this.tableDefinition = tableDefinition;
        this.scheduledExecutorService = siddhiAppContext.getScheduledExecutorService();
        this.siddhiAppContext = siddhiAppContext;
        this.init(tableDefinition, storeEventPool, storeEventCloner, configReader, siddhiAppContext);
    }

    protected abstract void init(TableDefinition var1, StreamEventPool var2, StreamEventCloner var3, ConfigReader var4, SiddhiAppContext var5);

    public TableDefinition getTableDefinition() {
        return this.tableDefinition;
    }

    public void addEvents(ComplexEventChunk<StreamEvent> addingEventChunk) {
        if (this.isConnected.get()) {
            try {
                this.add(addingEventChunk);
            }
            catch (ConnectionUnavailableException e) {
                this.isConnected.set(false);
                LOG.error((Object)(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext) + " Connection unavailable at Table '" + this.tableDefinition.getId() + "', will retry connection immediately."), (Throwable)e);
                this.connectWithRetry();
                this.addEvents(addingEventChunk);
            }
        } else if (this.isTryingToConnect.get()) {
            LOG.error((Object)("Error on '" + this.siddhiAppContext.getName() + "'. Dropping event at Table '" + this.tableDefinition.getId() + "' as its still trying to reconnect!, events dropped '" + addingEventChunk + "'"));
        } else {
            this.connectWithRetry();
            this.addEvents(addingEventChunk);
        }
    }

    protected abstract void add(ComplexEventChunk<StreamEvent> var1) throws ConnectionUnavailableException;

    @Override
    public StreamEvent find(StateEvent matchingEvent, CompiledCondition compiledCondition) {
        if (this.isConnected.get()) {
            try {
                return this.find(compiledCondition, matchingEvent);
            }
            catch (ConnectionUnavailableException e) {
                this.isConnected.set(false);
                LOG.error((Object)(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext) + " Connection unavailable at Table '" + this.tableDefinition.getId() + "', will retry connection immediately."), (Throwable)e);
                this.connectWithRetry();
                return this.find(matchingEvent, compiledCondition);
            }
        }
        if (this.isTryingToConnect.get()) {
            LOG.error((Object)("Error on '" + this.siddhiAppContext.getName() + "'. Find operation failed for event '" + matchingEvent + "', at Table '" + this.tableDefinition.getId() + "' as its still trying to reconnect!"));
            return null;
        }
        this.connectWithRetry();
        return this.find(matchingEvent, compiledCondition);
    }

    protected abstract StreamEvent find(CompiledCondition var1, StateEvent var2) throws ConnectionUnavailableException;

    public void deleteEvents(ComplexEventChunk<StateEvent> deletingEventChunk, CompiledCondition compiledCondition) {
        if (this.isConnected.get()) {
            try {
                this.delete(deletingEventChunk, compiledCondition);
            }
            catch (ConnectionUnavailableException e) {
                this.isConnected.set(false);
                LOG.error((Object)(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext) + " Connection unavailable at Table '" + this.tableDefinition.getId() + "', will retry connection immediately."), (Throwable)e);
                this.connectWithRetry();
                this.deleteEvents(deletingEventChunk, compiledCondition);
            }
        } else if (this.isTryingToConnect.get()) {
            LOG.error((Object)("Error on '" + this.siddhiAppContext.getName() + "'. Dropping event at Table '" + this.tableDefinition.getId() + "' as its still trying to reconnect!, events dropped '" + deletingEventChunk + "'"));
        } else {
            this.connectWithRetry();
            this.deleteEvents(deletingEventChunk, compiledCondition);
        }
    }

    protected abstract void delete(ComplexEventChunk<StateEvent> var1, CompiledCondition var2) throws ConnectionUnavailableException;

    public void updateEvents(ComplexEventChunk<StateEvent> updatingEventChunk, CompiledCondition compiledCondition, CompiledUpdateSet compiledUpdateSet) {
        if (this.isConnected.get()) {
            try {
                this.update(updatingEventChunk, compiledCondition, compiledUpdateSet);
            }
            catch (ConnectionUnavailableException e) {
                this.isConnected.set(false);
                LOG.error((Object)(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext) + " Connection unavailable at Table '" + this.tableDefinition.getId() + "', will retry connection immediately."), (Throwable)e);
                this.connectWithRetry();
                this.updateEvents(updatingEventChunk, compiledCondition, compiledUpdateSet);
            }
        } else if (this.isTryingToConnect.get()) {
            LOG.error((Object)("Error on '" + this.siddhiAppContext.getName() + "'. Dropping event at Table '" + this.tableDefinition.getId() + "' as its still trying to reconnect!, events dropped '" + updatingEventChunk + "'"));
        } else {
            this.connectWithRetry();
            this.updateEvents(updatingEventChunk, compiledCondition, compiledUpdateSet);
        }
    }

    protected abstract void update(ComplexEventChunk<StateEvent> var1, CompiledCondition var2, CompiledUpdateSet var3) throws ConnectionUnavailableException;

    public void updateOrAddEvents(ComplexEventChunk<StateEvent> updateOrAddingEventChunk, CompiledCondition compiledCondition, CompiledUpdateSet compiledUpdateSet, AddingStreamEventExtractor addingStreamEventExtractor) {
        if (this.isConnected.get()) {
            try {
                this.updateOrAdd(updateOrAddingEventChunk, compiledCondition, compiledUpdateSet, addingStreamEventExtractor);
            }
            catch (ConnectionUnavailableException e) {
                this.isConnected.set(false);
                LOG.error((Object)(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext) + " Connection unavailable at Table '" + this.tableDefinition.getId() + "', will retry connection immediately."), (Throwable)e);
                this.connectWithRetry();
                this.updateOrAddEvents(updateOrAddingEventChunk, compiledCondition, compiledUpdateSet, addingStreamEventExtractor);
            }
        } else if (this.isTryingToConnect.get()) {
            LOG.error((Object)("Error on '" + this.siddhiAppContext.getName() + "'. Dropping event at Table '" + this.tableDefinition.getId() + "' as its still trying to reconnect!, events dropped '" + updateOrAddingEventChunk + "'"));
        } else {
            this.connectWithRetry();
            this.updateOrAddEvents(updateOrAddingEventChunk, compiledCondition, compiledUpdateSet, addingStreamEventExtractor);
        }
    }

    protected abstract void updateOrAdd(ComplexEventChunk<StateEvent> var1, CompiledCondition var2, CompiledUpdateSet var3, AddingStreamEventExtractor var4) throws ConnectionUnavailableException;

    public boolean containsEvent(StateEvent matchingEvent, CompiledCondition compiledCondition) {
        if (this.isConnected.get()) {
            try {
                return this.contains(matchingEvent, compiledCondition);
            }
            catch (ConnectionUnavailableException e) {
                this.isConnected.set(false);
                LOG.error((Object)(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext) + " Connection unavailable at Table '" + this.tableDefinition.getId() + "', will retry connection immediately."), (Throwable)e);
                this.connectWithRetry();
                return this.containsEvent(matchingEvent, compiledCondition);
            }
        }
        if (this.isTryingToConnect.get()) {
            LOG.error((Object)("Error on '" + this.siddhiAppContext.getName() + "'. Dropping event at Table '" + this.tableDefinition.getId() + "' as its still trying to reconnect!, event matching failed for event '" + matchingEvent + "'."));
            return false;
        }
        this.connectWithRetry();
        return this.containsEvent(matchingEvent, compiledCondition);
    }

    protected abstract boolean contains(StateEvent var1, CompiledCondition var2) throws ConnectionUnavailableException;

    public void connectWithRetry() {
        if (!this.isConnected.get()) {
            this.isTryingToConnect.set(true);
            try {
                this.connect();
                this.isConnected.set(true);
                this.isTryingToConnect.set(false);
                this.backoffRetryCounter.reset();
            }
            catch (ConnectionUnavailableException e) {
                LOG.error((Object)(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext) + " Error while " + "connecting to Table '" + this.tableDefinition.getId() + "', will retry in '" + this.backoffRetryCounter.getTimeInterval() + "'."), (Throwable)e);
                this.scheduledExecutorService.schedule(new Runnable(){

                    @Override
                    public void run() {
                        Table.this.connectWithRetry();
                    }
                }, this.backoffRetryCounter.getTimeIntervalMillis(), TimeUnit.MILLISECONDS);
                this.backoffRetryCounter.increment();
            }
            catch (RuntimeException e) {
                LOG.error((Object)(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext) + " . Error while connecting to Table '" + this.tableDefinition.getId() + "'."), (Throwable)e);
                throw e;
            }
        }
    }

    public abstract CompiledUpdateSet compileUpdateSet(UpdateSet var1, MatchingMetaInfoHolder var2, SiddhiAppContext var3, List<VariableExpressionExecutor> var4, Map<String, Table> var5, String var6);

    protected abstract void connect() throws ConnectionUnavailableException;

    protected abstract void disconnect();

    protected abstract void destroy();

    public void shutdown() {
        this.disconnect();
        this.destroy();
        this.isConnected.set(false);
        this.isTryingToConnect.set(false);
    }
}

