/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.executor.incremental;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.exception.SiddhiAppRuntimeException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.core.executor.incremental.IncrementalTimeGetTimeZone;
import org.wso2.siddhi.core.executor.incremental.IncrementalUnixTimeFunctionExecutor;
import org.wso2.siddhi.core.util.IncrementalTimeConverterUtil;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.query.api.aggregation.TimePeriod;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.SiddhiAppValidationException;

public class IncrementalWithinTimeFunctionExecutor
extends FunctionExecutor {
    private boolean isSingleWithin = false;
    private Map<Integer, List<Pattern>> supportedGmtNonGmtRegexPatterns = new HashMap<Integer, List<Pattern>>();

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        if (attributeExpressionExecutors.length == 2) {
            if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
                throw new SiddhiAppValidationException("Only string values are supported for single within clause but found, " + attributeExpressionExecutors[0].getReturnType());
            }
            if (attributeExpressionExecutors[1].getReturnType() != Attribute.Type.LONG) {
                throw new SiddhiAppValidationException("Only supports checking whether a long value is within the given range, but found " + attributeExpressionExecutors[1].getReturnType());
            }
            this.isSingleWithin = true;
            this.setSupportedRegexPatterns();
        } else if (attributeExpressionExecutors.length == 3) {
            if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.LONG && attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
                throw new SiddhiAppValidationException("Only string and long types are supported as first value of within clause");
            }
            if (attributeExpressionExecutors[1].getReturnType() != Attribute.Type.LONG && attributeExpressionExecutors[1].getReturnType() != Attribute.Type.STRING) {
                throw new SiddhiAppValidationException("Only string and long types are supported as second value of within clause");
            }
            if (attributeExpressionExecutors[2].getReturnType() != Attribute.Type.LONG) {
                throw new SiddhiAppValidationException("Only supports checking whether a long value is within the given range, but found " + attributeExpressionExecutors[2].getReturnType());
            }
            this.setSupportedRegexPatterns();
        } else {
            throw new SiddhiAppValidationException("incrementalAggregator:within() function accepts only two or three arguments, but found " + attributeExpressionExecutors.length);
        }
    }

    @Override
    protected Object execute(Object[] data) {
        long timeStamp;
        long endTime;
        long startTime;
        if (this.isSingleWithin) {
            Long[] startTimeEndTime = this.getStartTimeEndTime(data[0].toString().trim());
            startTime = startTimeEndTime[0];
            endTime = startTimeEndTime[1];
            timeStamp = (Long)data[1];
        } else {
            startTime = data[0] instanceof Long ? (Long)data[0] : IncrementalUnixTimeFunctionExecutor.getUnixTimeStamp(data[0].toString());
            endTime = data[1] instanceof Long ? (Long)data[1] : IncrementalUnixTimeFunctionExecutor.getUnixTimeStamp(data[1].toString());
            timeStamp = (Long)data[2];
        }
        if (startTime >= endTime) {
            throw new SiddhiAppRuntimeException("The start time must be less than the end time in the within clause. However, the given start time is " + startTime + " and given end time is " + endTime + ", in unix time. Hence, start time is not less than end time.");
        }
        return startTime <= timeStamp && timeStamp < endTime;
    }

    @Override
    protected Object execute(Object data) {
        return null;
    }

    @Override
    public Attribute.Type getReturnType() {
        return Attribute.Type.BOOL;
    }

    @Override
    public Map<String, Object> currentState() {
        return null;
    }

    @Override
    public void restoreState(Map<String, Object> state) {
    }

    private void setSupportedRegexPatterns() {
        ArrayList<Pattern> gmtRegexPatterns = new ArrayList<Pattern>();
        ArrayList<Pattern> nonGmtRegexPatterns = new ArrayList<Pattern>();
        gmtRegexPatterns.add(Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}\\s[0-9]{2}[:][0-9]{2}[:][0-9]{2}"));
        gmtRegexPatterns.add(Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}\\s[0-9]{2}[:][0-9]{2}[:]\\*\\*"));
        gmtRegexPatterns.add(Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}\\s[0-9]{2}[:]\\*\\*[:]\\*\\*"));
        gmtRegexPatterns.add(Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}\\s\\*\\*[:]\\*\\*[:]\\*\\*"));
        gmtRegexPatterns.add(Pattern.compile("[0-9]{4}-[0-9]{2}-\\*\\*\\s\\*\\*[:]\\*\\*[:]\\*\\*"));
        gmtRegexPatterns.add(Pattern.compile("[0-9]{4}-\\*\\*-\\*\\*\\s\\*\\*[:]\\*\\*[:]\\*\\*"));
        nonGmtRegexPatterns.add(Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}\\s[0-9]{2}[:][0-9]{2}[:][0-9]{2}\\s[+-][0-9]{2}[:][0-9]{2}"));
        nonGmtRegexPatterns.add(Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}\\s[0-9]{2}[:][0-9]{2}[:]\\*\\*\\s[+-][0-9]{2}[:][0-9]{2}"));
        nonGmtRegexPatterns.add(Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}\\s[0-9]{2}[:]\\*\\*[:]\\*\\*\\s[+-][0-9]{2}[:][0-9]{2}"));
        nonGmtRegexPatterns.add(Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}\\s\\*\\*[:]\\*\\*[:]\\*\\*\\s[+-][0-9]{2}[:][0-9]{2}"));
        nonGmtRegexPatterns.add(Pattern.compile("[0-9]{4}-[0-9]{2}-\\*\\*\\s\\*\\*[:]\\*\\*[:]\\*\\*\\s[+-][0-9]{2}[:][0-9]{2}"));
        nonGmtRegexPatterns.add(Pattern.compile("[0-9]{4}-\\*\\*-\\*\\*\\s\\*\\*[:]\\*\\*[:]\\*\\*\\s[+-][0-9]{2}[:][0-9]{2}"));
        this.supportedGmtNonGmtRegexPatterns.put(19, gmtRegexPatterns);
        this.supportedGmtNonGmtRegexPatterns.put(26, nonGmtRegexPatterns);
    }

    private Long[] getStartTimeEndTime(String singleWithinTimeAsString) {
        List<Pattern> supportedPatterns = this.supportedGmtNonGmtRegexPatterns.get(singleWithinTimeAsString.length());
        if (supportedPatterns == null) {
            throw new SiddhiAppRuntimeException("Incorrect format provided for within clause. Supported formats for non GMT timezones are <yyyy>-**-** **:**:** <ZZ>, <yyyy>-<MM>-** **:**:** <ZZ>, <yyyy>-<MM>-<dd> **:**:** <ZZ>, <yyyy>-<MM>-<dd> <HH>:**:** <ZZ>, <yyyy>-<MM>-<dd> <HH>:<mm>:** <ZZ>, and <yyyy>-<MM>-<dd> <HH>:<mm>:<ss> <ZZ>. The ISO 8601 UTC offset must be provided for <ZZ> (ex. +05:30, -11:00). For GMT timezone the same formats must be adhered to, without <ZZ>");
        }
        for (int i = 0; i < TimePeriod.Duration.values().length; ++i) {
            if (!supportedPatterns.get(i).matcher(singleWithinTimeAsString).matches()) continue;
            switch (i) {
                case 0: {
                    long startTime = IncrementalUnixTimeFunctionExecutor.getUnixTimeStamp(singleWithinTimeAsString);
                    long endTime = startTime + 1000L;
                    return new Long[]{startTime, endTime};
                }
                case 1: {
                    long startTime = IncrementalUnixTimeFunctionExecutor.getUnixTimeStamp(singleWithinTimeAsString.replaceAll("\\*", "0"));
                    long endTime = startTime + 60000L;
                    return new Long[]{startTime, endTime};
                }
                case 2: {
                    long startTime = IncrementalUnixTimeFunctionExecutor.getUnixTimeStamp(singleWithinTimeAsString.replaceAll("\\*", "0"));
                    long endTime = startTime + 3600000L;
                    return new Long[]{startTime, endTime};
                }
                case 3: {
                    long startTime = IncrementalUnixTimeFunctionExecutor.getUnixTimeStamp(singleWithinTimeAsString.replaceAll("\\*", "0"));
                    long endTime = startTime + 86400000L;
                    return new Long[]{startTime, endTime};
                }
                case 4: {
                    long startTime = IncrementalUnixTimeFunctionExecutor.getUnixTimeStamp(singleWithinTimeAsString.replaceFirst("\\*\\*\\s\\*\\*[:]\\*\\*[:]\\*\\*", "01 00:00:00"));
                    String timeZone = IncrementalTimeGetTimeZone.getTimeZone(singleWithinTimeAsString.replaceFirst("\\*\\*\\s\\*\\*[:]\\*\\*[:]\\*\\*", "01 00:00:00"));
                    long endTime = IncrementalTimeConverterUtil.getNextEmitTime(startTime, TimePeriod.Duration.MONTHS, timeZone);
                    return new Long[]{startTime, endTime};
                }
                case 5: {
                    long startTime = IncrementalUnixTimeFunctionExecutor.getUnixTimeStamp(singleWithinTimeAsString.replaceFirst("\\*\\*-\\*\\*\\s\\*\\*[:]\\*\\*[:]\\*\\*", "01-01 00:00:00"));
                    String timeZone = IncrementalTimeGetTimeZone.getTimeZone(singleWithinTimeAsString.replaceFirst("\\*\\*-\\*\\*\\s\\*\\*[:]\\*\\*[:]\\*\\*", "01-01 00:00:00"));
                    long endTime = IncrementalTimeConverterUtil.getNextEmitTime(startTime, TimePeriod.Duration.YEARS, timeZone);
                    return new Long[]{startTime, endTime};
                }
            }
        }
        throw new SiddhiAppRuntimeException("Incorrect format provided for within clause. Supported formats for non GMT timezones are <yyyy>-**-** **:**:** <ZZ>, <yyyy>-<MM>-** **:**:** <ZZ>, <yyyy>-<MM>-<dd> **:**:** <ZZ>, <yyyy>-<MM>-<dd> <HH>:**:** <ZZ>, <yyyy>-<MM>-<dd> <HH>:<mm>:** <ZZ>, and <yyyy>-<MM>-<dd> <HH>:<mm>:<ss> <ZZ>. The ISO 8601 UTC offset must be provided for <ZZ> (ex. +05:30, -11:00). For GMT timezone the same formats must be adhered to, without <ZZ>");
    }
}

