/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.transport;

import java.util.ArrayList;
import java.util.List;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.util.transport.DynamicOptions;
import org.wso2.siddhi.core.util.transport.TemplateBuilder;

public class Option {
    private final String key;
    private final TemplateBuilder templateBuilder;
    private String value;
    private List<String> variableValues = new ArrayList<String>();
    private int dataIndex = -1;

    public Option(String key, String value, TemplateBuilder templateBuilder) {
        this.key = key;
        this.value = value;
        this.templateBuilder = templateBuilder;
    }

    public Option(int dataIndex) {
        this.key = null;
        this.templateBuilder = null;
        this.dataIndex = dataIndex;
    }

    int addVariableValue(String value) {
        this.variableValues.add(value);
        return this.variableValues.size() - 1;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isStatic() {
        return this.templateBuilder == null;
    }

    public String getValue(DynamicOptions dynamicOptions) {
        if (dynamicOptions.getVariableOptionIndex() != -1 && !this.variableValues.isEmpty()) {
            return this.variableValues.get(dynamicOptions.getVariableOptionIndex());
        }
        if (this.value != null) {
            return this.value;
        }
        if (this.templateBuilder != null) {
            return (String)this.templateBuilder.build(dynamicOptions.getEvent());
        }
        if (this.dataIndex != -1) {
            return (String)dynamicOptions.getEvent().getData(this.dataIndex);
        }
        return null;
    }

    public String getValue(Event event) {
        if (this.value != null) {
            return this.value;
        }
        if (this.templateBuilder != null) {
            return (String)this.templateBuilder.build(event);
        }
        if (this.dataIndex != -1) {
            return (String)event.getData(this.dataIndex);
        }
        return null;
    }
}

