/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.stream.output.sink;

import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.exception.ConnectionUnavailableException;
import org.wso2.siddhi.core.stream.output.sink.SinkHandler;
import org.wso2.siddhi.core.stream.output.sink.SinkHandlerCallback;
import org.wso2.siddhi.core.stream.output.sink.SinkListener;
import org.wso2.siddhi.core.stream.output.sink.SinkMapper;
import org.wso2.siddhi.core.util.ExceptionUtil;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.core.util.snapshot.Snapshotable;
import org.wso2.siddhi.core.util.transport.BackoffRetryCounter;
import org.wso2.siddhi.core.util.transport.DynamicOptions;
import org.wso2.siddhi.core.util.transport.OptionHolder;
import org.wso2.siddhi.query.api.annotation.Element;
import org.wso2.siddhi.query.api.definition.StreamDefinition;

public abstract class Sink
implements SinkListener,
Snapshotable {
    private static final Logger LOG = Logger.getLogger(Sink.class);
    private StreamDefinition streamDefinition;
    private String type;
    private SinkMapper mapper;
    private SinkHandler handler;
    private String elementId;
    private SiddhiAppContext siddhiAppContext;
    private AtomicBoolean isTryingToConnect = new AtomicBoolean(false);
    private BackoffRetryCounter backoffRetryCounter = new BackoffRetryCounter();
    private AtomicBoolean isConnected = new AtomicBoolean(false);
    private ThreadLocal<DynamicOptions> trpDynamicOptions;
    private ScheduledExecutorService scheduledExecutorService;

    public final void init(StreamDefinition streamDefinition, String type, OptionHolder transportOptionHolder, ConfigReader sinkConfigReader, SinkMapper sinkMapper, String mapType, OptionHolder mapOptionHolder, SinkHandler sinkHandler, List<Element> payloadElementList, ConfigReader mapperConfigReader, SiddhiAppContext siddhiAppContext) {
        this.streamDefinition = streamDefinition;
        this.type = type;
        this.elementId = siddhiAppContext.getElementIdGenerator().createNewId();
        this.siddhiAppContext = siddhiAppContext;
        this.init(streamDefinition, transportOptionHolder, sinkConfigReader, siddhiAppContext);
        if (sinkMapper != null) {
            sinkMapper.init(streamDefinition, mapType, mapOptionHolder, payloadElementList, this, mapperConfigReader, siddhiAppContext);
            this.mapper = sinkMapper;
        }
        if (sinkHandler != null) {
            sinkHandler.init(siddhiAppContext.getElementIdGenerator().createNewId(), streamDefinition, new SinkHandlerCallback(sinkMapper));
            this.handler = sinkHandler;
        }
        this.scheduledExecutorService = siddhiAppContext.getScheduledExecutorService();
    }

    public abstract Class[] getSupportedInputEventClasses();

    public final void initOnlyTransport(StreamDefinition streamDefinition, OptionHolder transportOptionHolder, ConfigReader sinkConfigReader, SiddhiAppContext siddhiAppContext) {
        this.streamDefinition = streamDefinition;
        this.elementId = siddhiAppContext.getElementIdGenerator().createNewId();
        this.siddhiAppContext = siddhiAppContext;
        this.init(streamDefinition, transportOptionHolder, sinkConfigReader, siddhiAppContext);
    }

    public abstract String[] getSupportedDynamicOptions();

    protected abstract void init(StreamDefinition var1, OptionHolder var2, ConfigReader var3, SiddhiAppContext var4);

    @Override
    public final void publish(Object payload) {
        if (this.isConnected.get()) {
            try {
                DynamicOptions dynamicOptions = this.trpDynamicOptions.get();
                this.publish(payload, dynamicOptions);
            }
            catch (ConnectionUnavailableException e) {
                this.isConnected.set(false);
                LOG.error((Object)(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext) + " Connection unavailable at Sink '" + this.type + "' at '" + this.streamDefinition.getId() + "', will retry connection immediately."), (Throwable)e);
                this.connectWithRetry();
                this.publish(payload);
            }
        } else if (this.isTryingToConnect.get()) {
            LOG.error((Object)("Error on '" + this.siddhiAppContext.getName() + "'. Dropping event at Sink '" + this.type + "' at '" + this.streamDefinition.getId() + "' as its still trying to reconnect!, events dropped '" + payload + "'"));
        } else {
            this.connectWithRetry();
            this.publish(payload);
        }
    }

    public abstract void publish(Object var1, DynamicOptions var2) throws ConnectionUnavailableException;

    public abstract void connect() throws ConnectionUnavailableException;

    public abstract void disconnect();

    public abstract void destroy();

    public final String getType() {
        return this.type;
    }

    public final SinkMapper getMapper() {
        return this.mapper;
    }

    public final SinkHandler getHandler() {
        return this.handler;
    }

    public void connectWithRetry() {
        if (!this.isConnected.get()) {
            this.isTryingToConnect.set(true);
            try {
                this.connect();
                this.isConnected.set(true);
                this.isTryingToConnect.set(false);
                this.backoffRetryCounter.reset();
            }
            catch (ConnectionUnavailableException e) {
                LOG.error((Object)(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext) + " Error while connecting at Sink '" + this.type + "' at '" + this.streamDefinition.getId() + "', will retry in '" + this.backoffRetryCounter.getTimeInterval() + "'."), (Throwable)e);
                this.scheduledExecutorService.schedule(new Runnable(){

                    @Override
                    public void run() {
                        Sink.this.connectWithRetry();
                    }
                }, this.backoffRetryCounter.getTimeIntervalMillis(), TimeUnit.MILLISECONDS);
                this.backoffRetryCounter.increment();
            }
            catch (RuntimeException e) {
                LOG.error((Object)(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext) + " Error while connecting at Sink '" + this.type + "' at '" + this.streamDefinition.getId() + "'."), (Throwable)e);
                throw e;
            }
        }
    }

    public boolean isConnected() {
        return this.isConnected.get();
    }

    public void shutdown() {
        this.disconnect();
        this.destroy();
        this.isConnected.set(false);
        this.isTryingToConnect.set(false);
    }

    @Override
    public final String getElementId() {
        return this.elementId;
    }

    void setTrpDynamicOptions(ThreadLocal<DynamicOptions> trpDynamicOptions) {
        this.trpDynamicOptions = trpDynamicOptions;
    }

    public StreamDefinition getStreamDefinition() {
        return this.streamDefinition;
    }
}

