/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.stream.input.source;

import java.util.List;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.stream.input.InputHandler;
import org.wso2.siddhi.core.stream.input.source.AttributeMapping;
import org.wso2.siddhi.core.stream.input.source.InputEventHandler;
import org.wso2.siddhi.core.stream.input.source.InputEventHandlerCallback;
import org.wso2.siddhi.core.stream.input.source.PassThroughSourceHandler;
import org.wso2.siddhi.core.stream.input.source.SourceEventListener;
import org.wso2.siddhi.core.stream.input.source.SourceHandler;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.core.util.transport.OptionHolder;
import org.wso2.siddhi.query.api.definition.StreamDefinition;

public abstract class SourceMapper
implements SourceEventListener {
    private static final Logger log = Logger.getLogger(SourceMapper.class);
    private final ThreadLocal<String[]> trpProperties = new ThreadLocal();
    private InputEventHandler inputEventHandler;
    private StreamDefinition streamDefinition;
    private String mapType;
    private String sourceType;
    private List<AttributeMapping> transportMappings;
    private SourceHandler sourceHandler;
    private SiddhiAppContext siddhiAppContext;

    public final void init(StreamDefinition streamDefinition, String mapType, OptionHolder mapOptionHolder, List<AttributeMapping> attributeMappings, String sourceType, List<AttributeMapping> transportMappings, SourceHandler sourceHandler, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        this.streamDefinition = streamDefinition;
        this.mapType = mapType;
        this.sourceType = sourceType;
        this.transportMappings = transportMappings;
        if (sourceHandler != null) {
            sourceHandler.initSourceHandler(siddhiAppContext.getElementIdGenerator().createNewId(), streamDefinition);
        }
        this.sourceHandler = sourceHandler;
        this.siddhiAppContext = siddhiAppContext;
        this.init(streamDefinition, mapOptionHolder, attributeMappings, configReader, siddhiAppContext);
    }

    public abstract void init(StreamDefinition var1, OptionHolder var2, List<AttributeMapping> var3, ConfigReader var4, SiddhiAppContext var5);

    public abstract Class[] getSupportedInputEventClasses();

    public final void setInputHandler(InputHandler inputHandler) {
        InputEventHandlerCallback inputEventHandlerCallback;
        if (this.sourceHandler != null) {
            this.sourceHandler.setInputHandler(inputHandler);
            inputEventHandlerCallback = this.sourceHandler;
        } else {
            inputEventHandlerCallback = new PassThroughSourceHandler(inputHandler);
        }
        this.inputEventHandler = new InputEventHandler(inputHandler, this.transportMappings, this.trpProperties, this.sourceType, this.siddhiAppContext, inputEventHandlerCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onEvent(Object eventObject, String[] transportProperties) {
        try {
            if (eventObject != null) {
                if (!this.allowNullInTransportProperties() && transportProperties != null) {
                    for (String property : transportProperties) {
                        if (property != null) continue;
                        log.error((Object)("Dropping event " + eventObject.toString() + " belonging to stream " + this.sourceHandler.getInputHandler().getStreamId() + " as it contains null transport properties and system " + "is configured to not allow null transport properties. You can " + "configure it via source mapper if the respective " + "mapper type allows it. Refer mapper documentation to verify " + "supportability"));
                        return;
                    }
                }
                this.trpProperties.set(transportProperties);
                this.mapAndProcess(eventObject, this.inputEventHandler);
            }
        }
        catch (InterruptedException | RuntimeException e) {
            log.error((Object)("Error while processing '" + eventObject + "', for the input Mapping '" + this.mapType + "' for the stream '" + this.streamDefinition.getId() + "'"));
        }
        finally {
            this.trpProperties.remove();
        }
    }

    public SourceHandler getHandler() {
        return this.sourceHandler;
    }

    @Override
    public final StreamDefinition getStreamDefinition() {
        return this.streamDefinition;
    }

    protected abstract void mapAndProcess(Object var1, InputEventHandler var2) throws InterruptedException;

    protected abstract boolean allowNullInTransportProperties();
}

