/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.selector.attribute.aggregator.incremental;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.query.selector.GroupByKeyGenerator;
import org.wso2.siddhi.core.query.selector.attribute.aggregator.incremental.BaseIncrementalValueStore;
import org.wso2.siddhi.core.query.selector.attribute.aggregator.incremental.IncrementalExecutor;
import org.wso2.siddhi.core.query.selector.attribute.processor.executor.GroupByAggregationAttributeExecutor;
import org.wso2.siddhi.core.table.Table;
import org.wso2.siddhi.core.util.IncrementalTimeConverterUtil;
import org.wso2.siddhi.query.api.aggregation.TimePeriod;

public class IncrementalDataAggregator {
    private final List<TimePeriod.Duration> incrementalDurations;
    private final TimePeriod.Duration aggregateForDuration;
    private final ExpressionExecutor timestampExecutor;
    private final ExpressionExecutor timeZoneExecutor;
    private final BaseIncrementalValueStore baseIncrementalValueStore;
    private final Map<Long, BaseIncrementalValueStore> baseIncrementalValueStoreMap;
    private final Map<Long, Map<String, BaseIncrementalValueStore>> baseIncrementalValueGroupByStoreMap;

    public IncrementalDataAggregator(List<TimePeriod.Duration> incrementalDurations, TimePeriod.Duration aggregateForDuration, List<ExpressionExecutor> baseExecutors, ExpressionExecutor timestampExecutor, MetaStreamEvent metaStreamEvent) {
        this.incrementalDurations = incrementalDurations;
        this.aggregateForDuration = aggregateForDuration;
        this.timestampExecutor = timestampExecutor;
        this.timeZoneExecutor = baseExecutors.get(0);
        StreamEventPool streamEventPool = new StreamEventPool(metaStreamEvent, 10);
        this.baseIncrementalValueStore = new BaseIncrementalValueStore(-1L, baseExecutors, streamEventPool);
        this.baseIncrementalValueStoreMap = new HashMap<Long, BaseIncrementalValueStore>();
        this.baseIncrementalValueGroupByStoreMap = new HashMap<Long, Map<String, BaseIncrementalValueStore>>();
    }

    public ComplexEventChunk<StreamEvent> aggregateInMemoryData(Map<TimePeriod.Duration, IncrementalExecutor> incrementalExecutorMap) {
        for (TimePeriod.Duration duration : this.incrementalDurations) {
            IncrementalExecutor incrementalExecutor = incrementalExecutorMap.get(duration);
            ArrayList<HashMap<String, BaseIncrementalValueStore>> baseIncrementalValueGroupByStoreList = incrementalExecutor.getBaseIncrementalValueGroupByStoreList();
            Map<String, BaseIncrementalValueStore> baseIncrementalValueStoreMap = incrementalExecutor.getBaseIncrementalValueStoreMap();
            ArrayList<BaseIncrementalValueStore> baseIncrementalValueStoreList = incrementalExecutor.getBaseIncrementalValueStoreList();
            BaseIncrementalValueStore baseIncrementalValueStore = incrementalExecutor.getBaseIncrementalValueStore();
            if (baseIncrementalValueGroupByStoreList != null) {
                for (HashMap hashMap : baseIncrementalValueGroupByStoreList) {
                    for (Map.Entry entry : hashMap.entrySet()) {
                        this.processInMemoryAggregates(((BaseIncrementalValueStore)entry.getValue()).createStreamEvent(), ((BaseIncrementalValueStore)entry.getValue()).getTimestamp(), (String)entry.getKey());
                    }
                }
            } else if (baseIncrementalValueStoreMap != null) {
                for (Map.Entry entry : baseIncrementalValueStoreMap.entrySet()) {
                    this.processInMemoryAggregates(((BaseIncrementalValueStore)entry.getValue()).createStreamEvent(), ((BaseIncrementalValueStore)entry.getValue()).getTimestamp(), (String)entry.getKey());
                }
            } else if (baseIncrementalValueStoreList != null) {
                for (BaseIncrementalValueStore baseIncrementalValueStore2 : baseIncrementalValueStoreList) {
                    this.processInMemoryAggregates(baseIncrementalValueStore2.createStreamEvent(), baseIncrementalValueStore2.getTimestamp(), null);
                }
            } else {
                this.processInMemoryAggregates(baseIncrementalValueStore.createStreamEvent(), baseIncrementalValueStore.getTimestamp(), null);
            }
            if (duration != this.aggregateForDuration) continue;
            break;
        }
        return this.createEventChunkFromAggregatedData();
    }

    public ComplexEventChunk<StreamEvent> aggregateTableData(Map<TimePeriod.Duration, Table> aggregationTables, GroupByKeyGenerator groupByKeyGenerator) {
        for (TimePeriod.Duration duration : this.incrementalDurations) {
            if (duration == this.aggregateForDuration) break;
        }
        return this.createEventChunkFromAggregatedData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInMemoryAggregates(StreamEvent streamEvent, long timestamp, String groupByKey) {
        String timeZone = this.timeZoneExecutor.execute(streamEvent).toString();
        long startTimeOfAggregates = IncrementalTimeConverterUtil.getStartTimeOfAggregates(timestamp, this.aggregateForDuration, timeZone);
        IncrementalDataAggregator incrementalDataAggregator = this;
        synchronized (incrementalDataAggregator) {
            if (groupByKey != null) {
                Map<String, BaseIncrementalValueStore> aBaseIncrementalValueStoreGroupBy = this.baseIncrementalValueGroupByStoreMap.get(startTimeOfAggregates);
                if (aBaseIncrementalValueStoreGroupBy == null) {
                    aBaseIncrementalValueStoreGroupBy = new HashMap<String, BaseIncrementalValueStore>();
                    this.baseIncrementalValueGroupByStoreMap.put(startTimeOfAggregates, aBaseIncrementalValueStoreGroupBy);
                }
                BaseIncrementalValueStore aBaseIncrementalValueStore = aBaseIncrementalValueStoreGroupBy.computeIfAbsent(groupByKey, k -> this.baseIncrementalValueStore.cloneStore((String)k, startTimeOfAggregates));
                this.process(streamEvent, aBaseIncrementalValueStore);
            } else {
                BaseIncrementalValueStore aBaseIncrementalValueStore = this.baseIncrementalValueStoreMap.get(startTimeOfAggregates);
                if (aBaseIncrementalValueStore == null) {
                    aBaseIncrementalValueStore = this.baseIncrementalValueStore.cloneStore(null, startTimeOfAggregates);
                    this.baseIncrementalValueStoreMap.put(startTimeOfAggregates, aBaseIncrementalValueStore);
                }
                this.process(streamEvent, aBaseIncrementalValueStore);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTableAggregates(StreamEvent streamEvent, GroupByKeyGenerator groupByKeyGenerator) {
        long timestamp = (Long)this.timestampExecutor.execute(streamEvent);
        String timeZone = this.timeZoneExecutor.execute(streamEvent).toString();
        long startTimeOfAggregates = IncrementalTimeConverterUtil.getStartTimeOfAggregates(timestamp, this.aggregateForDuration, timeZone);
        IncrementalDataAggregator incrementalDataAggregator = this;
        synchronized (incrementalDataAggregator) {
            if (groupByKeyGenerator != null) {
                try {
                    String groupByKey = groupByKeyGenerator.constructEventKey(streamEvent);
                    GroupByAggregationAttributeExecutor.getKeyThreadLocal().set(groupByKey);
                    Map<String, BaseIncrementalValueStore> aBaseIncrementalValueStoreGroupBy = this.baseIncrementalValueGroupByStoreMap.get(startTimeOfAggregates);
                    if (aBaseIncrementalValueStoreGroupBy == null) {
                        aBaseIncrementalValueStoreGroupBy = new HashMap<String, BaseIncrementalValueStore>();
                        this.baseIncrementalValueGroupByStoreMap.put(startTimeOfAggregates, aBaseIncrementalValueStoreGroupBy);
                    }
                    BaseIncrementalValueStore aBaseIncrementalValueStore = aBaseIncrementalValueStoreGroupBy.computeIfAbsent(groupByKey, k -> this.baseIncrementalValueStore.cloneStore((String)k, startTimeOfAggregates));
                    this.process(streamEvent, aBaseIncrementalValueStore);
                }
                finally {
                    GroupByAggregationAttributeExecutor.getKeyThreadLocal().remove();
                }
            } else {
                BaseIncrementalValueStore aBaseIncrementalValueStore = this.baseIncrementalValueStoreMap.get(startTimeOfAggregates);
                if (aBaseIncrementalValueStore == null) {
                    aBaseIncrementalValueStore = this.baseIncrementalValueStore.cloneStore(null, startTimeOfAggregates);
                    this.baseIncrementalValueStoreMap.put(startTimeOfAggregates, aBaseIncrementalValueStore);
                }
                this.process(streamEvent, aBaseIncrementalValueStore);
            }
        }
    }

    private void process(StreamEvent streamEvent, BaseIncrementalValueStore baseIncrementalValueStore) {
        List<ExpressionExecutor> expressionExecutors = baseIncrementalValueStore.getExpressionExecutors();
        for (int i = 0; i < expressionExecutors.size(); ++i) {
            ExpressionExecutor expressionExecutor = expressionExecutors.get(i);
            baseIncrementalValueStore.setValue(expressionExecutor.execute(streamEvent), i + 1);
        }
        baseIncrementalValueStore.setProcessed(true);
    }

    private ComplexEventChunk<StreamEvent> createEventChunkFromAggregatedData() {
        ComplexEventChunk<StreamEvent> processedInMemoryEventChunk = new ComplexEventChunk<StreamEvent>(true);
        if (this.baseIncrementalValueStoreMap.size() > 0) {
            for (Map.Entry<Long, BaseIncrementalValueStore> entryAgainstTime : this.baseIncrementalValueStoreMap.entrySet()) {
                processedInMemoryEventChunk.add(entryAgainstTime.getValue().createStreamEvent());
            }
        } else {
            for (Map.Entry<Long, Map<String, BaseIncrementalValueStore>> entryAgainstTime : this.baseIncrementalValueGroupByStoreMap.entrySet()) {
                for (Map.Entry<String, BaseIncrementalValueStore> entryAgainstKey : entryAgainstTime.getValue().entrySet()) {
                    processedInMemoryEventChunk.add(entryAgainstKey.getValue().createStreamEvent());
                }
            }
        }
        return processedInMemoryEventChunk;
    }
}

