/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.selector.attribute.aggregator.incremental;

import java.util.List;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.exception.SiddhiAppCreationException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.selector.attribute.aggregator.incremental.IncrementalExecutor;

public class IncrementalAggregationProcessor
implements Processor {
    private final List<ExpressionExecutor> incomingExpressionExecutors;
    private final MetaStreamEvent processedMetaStreamEvent;
    private final StreamEventPool streamEventPool;
    private IncrementalExecutor incrementalExecutor;

    public IncrementalAggregationProcessor(IncrementalExecutor incrementalExecutor, List<ExpressionExecutor> incomingExpressionExecutors, MetaStreamEvent processedMetaStreamEvent) {
        this.incrementalExecutor = incrementalExecutor;
        this.incomingExpressionExecutors = incomingExpressionExecutors;
        this.processedMetaStreamEvent = processedMetaStreamEvent;
        this.streamEventPool = new StreamEventPool(processedMetaStreamEvent, 5);
    }

    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        ComplexEventChunk<StreamEvent> streamEventChunk = new ComplexEventChunk<StreamEvent>(complexEventChunk.isBatch());
        while (complexEventChunk.hasNext()) {
            Object complexEvent = complexEventChunk.next();
            StreamEvent borrowedEvent = this.streamEventPool.borrowEvent();
            for (int i = 0; i < this.incomingExpressionExecutors.size(); ++i) {
                ExpressionExecutor expressionExecutor = this.incomingExpressionExecutors.get(i);
                borrowedEvent.setOutputData(expressionExecutor.execute((ComplexEvent)complexEvent), i);
            }
            streamEventChunk.add(borrowedEvent);
        }
        this.incrementalExecutor.execute(streamEventChunk);
    }

    @Override
    public Processor getNextProcessor() {
        return null;
    }

    @Override
    public void setNextProcessor(Processor processor) {
        throw new SiddhiAppCreationException("IncrementalAggregationProcessor does not support any next processor");
    }

    @Override
    public void setToLast(Processor processor) {
        throw new SiddhiAppCreationException("IncrementalAggregationProcessor does not support any next/last processor");
    }

    @Override
    public Processor cloneProcessor(String key) {
        throw new SiddhiAppCreationException("IncrementalAggregationProcessor cannot be cloned");
    }
}

