/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.selector.attribute.aggregator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.ReturnAttribute;
import org.wso2.siddhi.annotation.util.DataType;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.exception.OperationNotSupportedException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.query.selector.attribute.aggregator.AttributeAggregator;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.query.api.definition.Attribute;

@Extension(name="minForever", namespace="", description="This is the attribute aggregator to store the minimum value for a given attribute throughout the lifetime of the query regardless of any windows in-front.", parameters={@Parameter(name="arg", description="The value that needs to be compared to find the minimum value.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT})}, returnAttributes={@ReturnAttribute(description="Returns the minimum value in the same data type as the input.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT})}, examples={@Example(syntax="from inputStream\nselect minForever(temp) as max\ninsert into outputStream;", description="minForever(temp) returns the minimum temp value recorded for all the events throughoutthe lifetime of the query.")})
public class MinForeverAttributeAggregator
extends AttributeAggregator {
    private MinForeverAttributeAggregator minForeverAttributeAggregator;

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new OperationNotSupportedException("MinForever aggregator has to have exactly 1 parameter, currently " + attributeExpressionExecutors.length + " parameters provided");
        }
        Attribute.Type type = attributeExpressionExecutors[0].getReturnType();
        switch (type) {
            case FLOAT: {
                this.minForeverAttributeAggregator = new MinForeverAttributeAggregatorFloat();
                break;
            }
            case INT: {
                this.minForeverAttributeAggregator = new MinForeverAttributeAggregatorInt();
                break;
            }
            case LONG: {
                this.minForeverAttributeAggregator = new MinForeverAttributeAggregatorLong();
                break;
            }
            case DOUBLE: {
                this.minForeverAttributeAggregator = new MinForeverAttributeAggregatorDouble();
                break;
            }
            default: {
                throw new OperationNotSupportedException("MinForever not supported for " + type);
            }
        }
    }

    @Override
    public Attribute.Type getReturnType() {
        return this.minForeverAttributeAggregator.getReturnType();
    }

    @Override
    public Object processAdd(Object data) {
        return this.minForeverAttributeAggregator.processAdd(data);
    }

    @Override
    public Object processAdd(Object[] data) {
        return new IllegalStateException("MinForever cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object processRemove(Object data) {
        return this.minForeverAttributeAggregator.processRemove(data);
    }

    @Override
    public Object processRemove(Object[] data) {
        return new IllegalStateException("MinForever cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public boolean canDestroy() {
        return false;
    }

    @Override
    public Object reset() {
        return this.minForeverAttributeAggregator.reset();
    }

    @Override
    public Map<String, Object> currentState() {
        return this.minForeverAttributeAggregator.currentState();
    }

    @Override
    public void restoreState(Map<String, Object> state) {
        this.minForeverAttributeAggregator.restoreState(state);
    }

    class MinForeverAttributeAggregatorLong
    extends MinForeverAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.LONG;
        private volatile Long minValue = null;

        MinForeverAttributeAggregatorLong() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public synchronized Object processAdd(Object data) {
            Long value = (Long)data;
            if (this.minValue == null || this.minValue > value) {
                this.minValue = value;
            }
            return this.minValue;
        }

        @Override
        public Object reset() {
            return this.minValue;
        }

        @Override
        public synchronized Object processRemove(Object data) {
            Long value = (Long)data;
            if (this.minValue == null || this.minValue > value) {
                this.minValue = value;
            }
            return this.minValue;
        }

        @Override
        public Map<String, Object> currentState() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("MinValue", this.minValue);
            return state;
        }

        @Override
        public void restoreState(Map<String, Object> state) {
            this.minValue = (Long)state.get("MinValue");
        }
    }

    class MinForeverAttributeAggregatorInt
    extends MinForeverAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.INT;
        private volatile Integer minValue = null;

        MinForeverAttributeAggregatorInt() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public synchronized Object processAdd(Object data) {
            Integer value = (Integer)data;
            if (this.minValue == null || this.minValue > value) {
                this.minValue = value;
            }
            return this.minValue;
        }

        @Override
        public Object reset() {
            return this.minValue;
        }

        @Override
        public synchronized Object processRemove(Object data) {
            Integer value = (Integer)data;
            if (this.minValue == null || this.minValue > value) {
                this.minValue = value;
            }
            return this.minValue;
        }

        @Override
        public Map<String, Object> currentState() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("MinValue", this.minValue);
            return state;
        }

        @Override
        public void restoreState(Map<String, Object> state) {
            this.minValue = (Integer)state.get("MinValue");
        }
    }

    class MinForeverAttributeAggregatorFloat
    extends MinForeverAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.FLOAT;
        private volatile Float minValue = null;

        MinForeverAttributeAggregatorFloat() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public synchronized Object processAdd(Object data) {
            Float value = (Float)data;
            if (this.minValue == null || this.minValue.floatValue() > value.floatValue()) {
                this.minValue = value;
            }
            return this.minValue;
        }

        @Override
        public synchronized Object processRemove(Object data) {
            Float value = (Float)data;
            if (this.minValue == null || this.minValue.floatValue() > value.floatValue()) {
                this.minValue = value;
            }
            return this.minValue;
        }

        @Override
        public Object reset() {
            return this.minValue;
        }

        @Override
        public Map<String, Object> currentState() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("MinValue", this.minValue);
            return state;
        }

        @Override
        public void restoreState(Map<String, Object> state) {
            this.minValue = (Float)state.get("MinValue");
        }
    }

    class MinForeverAttributeAggregatorDouble
    extends MinForeverAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.DOUBLE;
        private volatile Double minValue = null;

        MinForeverAttributeAggregatorDouble() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public synchronized Object processAdd(Object data) {
            Double value = (Double)data;
            if (this.minValue == null || this.minValue > value) {
                this.minValue = value;
            }
            return this.minValue;
        }

        @Override
        public synchronized Object processRemove(Object data) {
            Double value = (Double)data;
            if (this.minValue == null || this.minValue > value) {
                this.minValue = value;
            }
            return this.minValue;
        }

        @Override
        public Object reset() {
            return this.minValue;
        }

        @Override
        public Map<String, Object> currentState() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("MinValue", this.minValue);
            return state;
        }

        @Override
        public void restoreState(Map<String, Object> state) {
            this.minValue = (Double)state.get("MinValue");
        }
    }
}

