/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.input.stream.state;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.query.input.stream.single.EntryValveProcessor;
import org.wso2.siddhi.core.query.input.stream.state.AbsentPreStateProcessor;
import org.wso2.siddhi.core.query.input.stream.state.PreStateProcessor;
import org.wso2.siddhi.core.query.input.stream.state.StreamPreStateProcessor;
import org.wso2.siddhi.core.util.Scheduler;
import org.wso2.siddhi.core.util.parser.SchedulerParser;
import org.wso2.siddhi.query.api.execution.query.input.stream.StateInputStream;
import org.wso2.siddhi.query.api.expression.constant.TimeConstant;

public class AbsentStreamPreStateProcessor
extends StreamPreStateProcessor
implements AbsentPreStateProcessor {
    private Scheduler scheduler;
    private long waitingTime = -1L;
    private long lastArrivalTime;
    private boolean active = true;
    private TimeConstant waitingTimeConstant;

    public AbsentStreamPreStateProcessor(StateInputStream.Type stateType, List<Map.Entry<Long, Set<Integer>>> withinStates, TimeConstant waitingTime) {
        super(stateType, withinStates);
        this.waitingTime = waitingTime.value();
        this.waitingTimeConstant = waitingTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLastArrivalTime(long timestamp) {
        AbsentStreamPreStateProcessor absentStreamPreStateProcessor = this;
        synchronized (absentStreamPreStateProcessor) {
            this.lastArrivalTime = timestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addState(StateEvent stateEvent) {
        if (!this.active) {
            return;
        }
        AbsentStreamPreStateProcessor absentStreamPreStateProcessor = this;
        synchronized (absentStreamPreStateProcessor) {
            if (this.stateType == StateInputStream.Type.SEQUENCE) {
                this.newAndEveryStateEventList.clear();
                this.newAndEveryStateEventList.add(stateEvent);
            } else {
                this.newAndEveryStateEventList.add(stateEvent);
            }
        }
        if (!this.isStartState) {
            this.scheduler.notifyAt(stateEvent.getTimestamp() + this.waitingTime);
        }
    }

    @Override
    public void resetState() {
        this.pendingStateEventList.clear();
        if (this.isStartState) {
            if (this.stateType == StateInputStream.Type.SEQUENCE && this.thisStatePostProcessor.nextEveryStatePerProcessor == null && !((StreamPreStateProcessor)this.thisStatePostProcessor.nextStatePerProcessor).pendingStateEventList.isEmpty()) {
                return;
            }
            this.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        if (!this.active) {
            return;
        }
        boolean notProcessed = true;
        long currentTime = complexEventChunk.getFirst().getTimestamp();
        if (currentTime >= this.lastArrivalTime + this.waitingTime) {
            AbsentStreamPreStateProcessor absentStreamPreStateProcessor = this;
            synchronized (absentStreamPreStateProcessor) {
                boolean initialize;
                boolean bl = initialize = this.isStartState && this.newAndEveryStateEventList.isEmpty() && this.pendingStateEventList.isEmpty();
                if (initialize && this.stateType == StateInputStream.Type.SEQUENCE && this.thisStatePostProcessor.nextEveryStatePerProcessor == null && this.lastArrivalTime > 0L) {
                    initialize = false;
                }
                if (initialize) {
                    StateEvent stateEvent = this.stateEventPool.borrowEvent();
                    this.addState(stateEvent);
                } else if (this.stateType == StateInputStream.Type.SEQUENCE && !this.newAndEveryStateEventList.isEmpty()) {
                    this.resetState();
                }
                this.updateState();
                ComplexEventChunk<StateEvent> retEventChunk = new ComplexEventChunk<StateEvent>(false);
                Iterator iterator = this.pendingStateEventList.iterator();
                while (iterator.hasNext()) {
                    StateEvent event = (StateEvent)iterator.next();
                    if (this.withinStates.size() > 0 && this.isExpired(event, currentTime)) {
                        iterator.remove();
                        continue;
                    }
                    if (currentTime < event.getTimestamp() + this.waitingTime) continue;
                    iterator.remove();
                    event.setTimestamp(currentTime);
                    retEventChunk.add(event);
                }
                boolean bl2 = notProcessed = retEventChunk.getFirst() == null;
                while (retEventChunk.hasNext()) {
                    StateEvent stateEvent = (StateEvent)retEventChunk.next();
                    retEventChunk.remove();
                    this.sendEvent(stateEvent);
                }
            }
            this.lastArrivalTime = 0L;
        }
        if (this.thisStatePostProcessor.nextEveryStatePerProcessor == this || notProcessed && this.isStartState) {
            long nextBreak = this.lastArrivalTime == 0L ? currentTime + this.waitingTime : this.lastArrivalTime + this.waitingTime;
            this.scheduler.notifyAt(nextBreak);
        }
    }

    private void sendEvent(StateEvent stateEvent) {
        if (this.thisStatePostProcessor.nextProcessor != null) {
            this.thisStatePostProcessor.nextProcessor.process(new ComplexEventChunk<StateEvent>(stateEvent, stateEvent, false));
        }
        if (this.thisStatePostProcessor.nextStatePerProcessor != null) {
            this.thisStatePostProcessor.nextStatePerProcessor.addState(stateEvent);
        }
        if (this.thisStatePostProcessor.nextEveryStatePerProcessor != null) {
            this.thisStatePostProcessor.nextEveryStatePerProcessor.addEveryState(stateEvent);
        } else if (this.isStartState) {
            this.active = false;
        }
        if (this.thisStatePostProcessor.callbackPreStateProcessor != null) {
            this.thisStatePostProcessor.callbackPreStateProcessor.startStateReset();
        }
    }

    @Override
    public ComplexEventChunk<StateEvent> processAndReturn(ComplexEventChunk complexEventChunk) {
        if (!this.active) {
            return new ComplexEventChunk<StateEvent>(false);
        }
        ComplexEventChunk<StateEvent> event = super.processAndReturn(complexEventChunk);
        StateEvent firstEvent = event.getFirst();
        if (firstEvent != null) {
            event = new ComplexEventChunk(false);
        }
        return event;
    }

    @Override
    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public PreStateProcessor cloneProcessor(String key) {
        AbsentStreamPreStateProcessor streamPreStateProcessor = new AbsentStreamPreStateProcessor(this.stateType, this.withinStates, this.waitingTimeConstant);
        this.cloneProperties(streamPreStateProcessor, key);
        streamPreStateProcessor.init(this.siddhiAppContext, this.queryName);
        this.siddhiAppContext.addEternalReferencedHolder(streamPreStateProcessor);
        EntryValveProcessor entryValveProcessor = new EntryValveProcessor(this.siddhiAppContext);
        entryValveProcessor.setToLast(streamPreStateProcessor);
        Scheduler scheduler = SchedulerParser.parse(this.siddhiAppContext.getScheduledExecutorService(), entryValveProcessor, this.siddhiAppContext);
        streamPreStateProcessor.setScheduler(scheduler);
        return streamPreStateProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.isStartState && this.waitingTime != -1L && this.active) {
            AbsentStreamPreStateProcessor absentStreamPreStateProcessor = this;
            synchronized (absentStreamPreStateProcessor) {
                this.scheduler.notifyAt(this.siddhiAppContext.getTimestampGenerator().currentTime() + this.waitingTime);
            }
        }
    }

    @Override
    public void stop() {
    }
}

