/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.input.stream.join;

import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.state.StateEventPool;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.processor.stream.window.FindableProcessor;
import org.wso2.siddhi.core.query.selector.QuerySelector;
import org.wso2.siddhi.core.util.collection.operator.CompiledCondition;
import org.wso2.siddhi.core.util.lock.LockWrapper;

public class JoinProcessor
implements Processor {
    private boolean trigger;
    private boolean leftJoinProcessor = false;
    private boolean outerJoinProcessor = false;
    private int matchingStreamIndex;
    private LockWrapper joinLockWrapper;
    private boolean preJoinProcessor;
    private StateEventPool stateEventPool;
    private CompiledCondition compiledCondition;
    private FindableProcessor findableProcessor;
    private Processor nextProcessor;
    private QuerySelector selector;

    public JoinProcessor(boolean leftJoinProcessor, boolean preJoinProcessor, boolean outerJoinProcessor, int matchingStreamIndex) {
        this.leftJoinProcessor = leftJoinProcessor;
        this.preJoinProcessor = preJoinProcessor;
        this.outerJoinProcessor = outerJoinProcessor;
        this.matchingStreamIndex = matchingStreamIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        if (this.trigger) {
            ComplexEventChunk<StateEvent> returnEventChunk = new ComplexEventChunk<StateEvent>(true);
            StateEvent joinStateEvent = new StateEvent(2, 0);
            StreamEvent nextEvent = (StreamEvent)complexEventChunk.getFirst();
            complexEventChunk.clear();
            while (nextEvent != null) {
                block19: {
                    StreamEvent streamEvent = nextEvent;
                    nextEvent = streamEvent.getNext();
                    streamEvent.setNext(null);
                    this.joinLockWrapper.lock();
                    try {
                        ComplexEvent.Type eventType = streamEvent.getType();
                        if (eventType == ComplexEvent.Type.TIMER) continue;
                        if (eventType == ComplexEvent.Type.RESET) {
                            if (!this.leftJoinProcessor) {
                                returnEventChunk.add(this.joinEventBuilder(null, streamEvent, eventType));
                            } else {
                                returnEventChunk.add(this.joinEventBuilder(streamEvent, null, eventType));
                            }
                            break block19;
                        }
                        joinStateEvent.setEvent(this.matchingStreamIndex, streamEvent);
                        StreamEvent foundStreamEvent = this.findableProcessor.find(joinStateEvent, this.compiledCondition);
                        joinStateEvent.setEvent(this.matchingStreamIndex, null);
                        if (foundStreamEvent == null) {
                            if (this.outerJoinProcessor && !this.leftJoinProcessor) {
                                returnEventChunk.add(this.joinEventBuilder(null, streamEvent, eventType));
                                break block19;
                            }
                            if (!this.outerJoinProcessor || !this.leftJoinProcessor) break block19;
                            returnEventChunk.add(this.joinEventBuilder(streamEvent, null, eventType));
                            break block19;
                        }
                        while (foundStreamEvent != null) {
                            StreamEvent nextFoundStreamEvent = foundStreamEvent.getNext();
                            foundStreamEvent.setNext(null);
                            if (!this.leftJoinProcessor) {
                                returnEventChunk.add(this.joinEventBuilder(foundStreamEvent, streamEvent, eventType));
                            } else {
                                returnEventChunk.add(this.joinEventBuilder(streamEvent, foundStreamEvent, eventType));
                            }
                            foundStreamEvent = nextFoundStreamEvent;
                        }
                    }
                    finally {
                        this.joinLockWrapper.unlock();
                        continue;
                    }
                }
                if (returnEventChunk.getFirst() == null) continue;
                this.selector.process(returnEventChunk);
                returnEventChunk.clear();
            }
        } else if (this.preJoinProcessor) {
            this.joinLockWrapper.lock();
            try {
                this.nextProcessor.process(complexEventChunk);
            }
            finally {
                this.joinLockWrapper.unlock();
            }
        }
    }

    @Override
    public Processor getNextProcessor() {
        return this.nextProcessor;
    }

    @Override
    public void setNextProcessor(Processor processor) {
        this.nextProcessor = processor;
    }

    public void setJoinLock(LockWrapper joinLockWrapper) {
        this.joinLockWrapper = joinLockWrapper;
    }

    @Override
    public void setToLast(Processor processor) {
        if (this.nextProcessor == null) {
            this.nextProcessor = processor;
        } else {
            this.nextProcessor.setToLast(processor);
        }
        if (processor instanceof QuerySelector) {
            this.selector = (QuerySelector)processor;
        }
    }

    @Override
    public Processor cloneProcessor(String key) {
        JoinProcessor joinProcessor = new JoinProcessor(this.leftJoinProcessor, this.preJoinProcessor, this.outerJoinProcessor, this.matchingStreamIndex);
        joinProcessor.setTrigger(this.trigger);
        if (this.trigger) {
            joinProcessor.setCompiledCondition(this.compiledCondition.cloneCompiledCondition(key));
        }
        return joinProcessor;
    }

    public void setFindableProcessor(FindableProcessor findableProcessor) {
        this.findableProcessor = findableProcessor;
    }

    public void setCompiledCondition(CompiledCondition compiledCondition) {
        this.compiledCondition = compiledCondition;
    }

    public void setTrigger(boolean trigger) {
        this.trigger = trigger;
    }

    public void setStateEventPool(StateEventPool stateEventPool) {
        this.stateEventPool = stateEventPool;
    }

    public StateEvent joinEventBuilder(StreamEvent leftStream, StreamEvent rightStream, ComplexEvent.Type type) {
        StateEvent returnEvent = this.stateEventPool.borrowEvent();
        returnEvent.setEvent(0, leftStream);
        returnEvent.setEvent(1, rightStream);
        returnEvent.setType(type);
        if (!this.leftJoinProcessor) {
            returnEvent.setTimestamp(rightStream.getTimestamp());
        } else {
            returnEvent.setTimestamp(leftStream.getTimestamp());
        }
        return returnEvent;
    }
}

