/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.output.ratelimit.time;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.query.output.ratelimit.OutputRateLimiter;
import org.wso2.siddhi.core.util.Schedulable;
import org.wso2.siddhi.core.util.Scheduler;
import org.wso2.siddhi.core.util.parser.SchedulerParser;

public class AllPerTimeOutputRateLimiter
extends OutputRateLimiter
implements Schedulable {
    private static final Logger log = Logger.getLogger(AllPerTimeOutputRateLimiter.class);
    private final Long value;
    private String id;
    private ScheduledExecutorService scheduledExecutorService;
    private Scheduler scheduler;
    private ComplexEventChunk<ComplexEvent> allComplexEventChunk;
    private long scheduledTime;
    private String queryName;

    public AllPerTimeOutputRateLimiter(String id, Long value, ScheduledExecutorService scheduledExecutorService, String queryName) {
        this.id = id;
        this.value = value;
        this.queryName = queryName;
        this.scheduledExecutorService = scheduledExecutorService;
        this.allComplexEventChunk = new ComplexEventChunk(false);
    }

    @Override
    public OutputRateLimiter clone(String key) {
        AllPerTimeOutputRateLimiter instance = new AllPerTimeOutputRateLimiter(this.id + key, this.value, this.scheduledExecutorService, this.queryName);
        instance.setLatencyTracker(this.latencyTracker);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        ArrayList outputEventChunks = new ArrayList();
        complexEventChunk.reset();
        AllPerTimeOutputRateLimiter allPerTimeOutputRateLimiter = this;
        synchronized (allPerTimeOutputRateLimiter) {
            while (complexEventChunk.hasNext()) {
                Object object = complexEventChunk.next();
                if (object.getType() == ComplexEvent.Type.TIMER) {
                    if (object.getTimestamp() < this.scheduledTime) continue;
                    ComplexEvent first = this.allComplexEventChunk.getFirst();
                    if (first != null) {
                        this.allComplexEventChunk.clear();
                        ComplexEventChunk<ComplexEvent> outputEventChunk = new ComplexEventChunk<ComplexEvent>(complexEventChunk.isBatch());
                        outputEventChunk.add(first);
                        outputEventChunks.add(outputEventChunk);
                    }
                    this.scheduledTime += this.value.longValue();
                    this.scheduler.notifyAt(this.scheduledTime);
                    continue;
                }
                if (object.getType() != ComplexEvent.Type.CURRENT && object.getType() != ComplexEvent.Type.EXPIRED) continue;
                complexEventChunk.remove();
                this.allComplexEventChunk.add((ComplexEvent)object);
            }
        }
        for (ComplexEventChunk complexEventChunk2 : outputEventChunks) {
            this.sendToCallBacks(complexEventChunk2);
        }
    }

    @Override
    public void start() {
        this.scheduler = SchedulerParser.parse(this.scheduledExecutorService, this, this.siddhiAppContext);
        this.scheduler.setStreamEventPool(new StreamEventPool(0, 0, 0, 5));
        this.scheduler.init(this.lockWrapper, this.queryName);
        long currentTime = System.currentTimeMillis();
        this.scheduledTime = currentTime + this.value;
        this.scheduler.notifyAt(this.scheduledTime);
    }

    @Override
    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> currentState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        AllPerTimeOutputRateLimiter allPerTimeOutputRateLimiter = this;
        synchronized (allPerTimeOutputRateLimiter) {
            state.put("AllComplexEventChunk", this.allComplexEventChunk.getFirst());
        }
        return state;
    }

    @Override
    public synchronized void restoreState(Map<String, Object> state) {
        this.allComplexEventChunk.clear();
        this.allComplexEventChunk.add((ComplexEvent)state.get("AllComplexEventChunk"));
    }
}

