/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.executor.function;

import java.util.Map;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.ReturnAttribute;
import org.wso2.siddhi.annotation.util.DataType;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.core.util.timestamp.TimestampGenerator;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.SiddhiAppValidationException;

@Extension(name="currentTimeMillis", namespace="", description="Returns the current timestamp of siddhi application in milliseconds.", parameters={}, returnAttributes={@ReturnAttribute(description="siddhi application's current timestamp in milliseconds.", type={DataType.LONG})}, examples={@Example(syntax="from fooStream\nselect symbol as name, currentTimeMillis() as eventTimestamp \ninsert into barStream;", description="This will extract current siddhi application timestamp.")})
public class CurrentTimeMillisFunctionExecutor
extends FunctionExecutor {
    private TimestampGenerator timestampGenerator;

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        if (attributeExpressionExecutors.length != 0) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to eventTimestamp() function, required 0 parameters, but found " + attributeExpressionExecutors.length);
        }
        this.timestampGenerator = siddhiAppContext.getTimestampGenerator();
    }

    @Override
    public Object execute(ComplexEvent event) {
        return this.timestampGenerator.currentTime();
    }

    @Override
    protected Object execute(Object[] data) {
        return null;
    }

    @Override
    protected Object execute(Object data) {
        return null;
    }

    @Override
    public Attribute.Type getReturnType() {
        return Attribute.Type.LONG;
    }

    @Override
    public Map<String, Object> currentState() {
        return null;
    }

    @Override
    public void restoreState(Map<String, Object> state) {
    }
}

