/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.snapshot;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.util.ExceptionUtil;

public class ByteSerializer {
    private static final Logger log = Logger.getLogger(ByteSerializer.class);

    private ByteSerializer() {
    }

    public static byte[] objectToByte(Object obj, SiddhiAppContext siddhiAppContext) {
        long start = System.currentTimeMillis();
        byte[] out = null;
        if (obj != null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(obj);
                out = baos.toByteArray();
            }
            catch (IOException e) {
                log.error((Object)(ExceptionUtil.getMessageWithContext(e, siddhiAppContext) + " Error when writing byte array."), (Throwable)e);
                return null;
            }
        }
        long end = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("For SiddhiApp '" + siddhiAppContext.getName() + "'. Encoded in :" + (end - start) + " msec"));
        }
        return out;
    }

    public static Object byteToObject(byte[] bytes, SiddhiAppContext siddhiAppContext) {
        long start = System.currentTimeMillis();
        Object out = null;
        if (bytes != null) {
            try {
                ByteArrayInputStream bios = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bios);
                out = ois.readObject();
            }
            catch (IOException e) {
                log.error((Object)(ExceptionUtil.getMessageWithContext(e, siddhiAppContext) + " Error when writing to object."), (Throwable)e);
                return null;
            }
            catch (ClassNotFoundException e) {
                log.error((Object)(ExceptionUtil.getMessageWithContext(e, siddhiAppContext) + " Error when writing to object."), (Throwable)e);
                return null;
            }
        }
        long end = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Decoded in :" + (end - start) + " msec"));
        }
        return out;
    }
}

