/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.stream.input.source;

import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.exception.ConnectionUnavailableException;
import org.wso2.siddhi.core.stream.input.source.AttributeMapping;
import org.wso2.siddhi.core.stream.input.source.SourceEventListener;
import org.wso2.siddhi.core.stream.input.source.SourceHandler;
import org.wso2.siddhi.core.stream.input.source.SourceMapper;
import org.wso2.siddhi.core.util.ExceptionUtil;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.core.util.snapshot.Snapshotable;
import org.wso2.siddhi.core.util.transport.BackoffRetryCounter;
import org.wso2.siddhi.core.util.transport.OptionHolder;
import org.wso2.siddhi.query.api.definition.StreamDefinition;

public abstract class Source
implements Snapshotable {
    private static final Logger LOG = Logger.getLogger(Source.class);
    private String type;
    private SourceMapper mapper;
    private StreamDefinition streamDefinition;
    private String elementId;
    private SiddhiAppContext siddhiAppContext;
    private AtomicBoolean isTryingToConnect = new AtomicBoolean(false);
    private BackoffRetryCounter backoffRetryCounter = new BackoffRetryCounter();
    private AtomicBoolean isConnected = new AtomicBoolean(false);
    private ScheduledExecutorService scheduledExecutorService;
    private ConnectionCallback connectionCallback = new ConnectionCallback();

    public final void init(String sourceType, OptionHolder transportOptionHolder, SourceMapper sourceMapper, String[] transportPropertyNames, ConfigReader configReader, String mapType, OptionHolder mapOptionHolder, List<AttributeMapping> attributeMappings, List<AttributeMapping> transportMappings, ConfigReader mapperConfigReader, SourceHandler sourceHandler, StreamDefinition streamDefinition, SiddhiAppContext siddhiAppContext) {
        this.type = sourceType;
        sourceMapper.init(streamDefinition, mapType, mapOptionHolder, attributeMappings, sourceType, transportMappings, sourceHandler, mapperConfigReader, siddhiAppContext);
        this.mapper = sourceMapper;
        this.streamDefinition = streamDefinition;
        this.elementId = siddhiAppContext.getElementIdGenerator().createNewId();
        this.siddhiAppContext = siddhiAppContext;
        if (sourceHandler != null) {
            sourceHandler.initSourceHandler(this.elementId, streamDefinition);
        }
        this.init(sourceMapper, transportOptionHolder, transportPropertyNames, configReader, siddhiAppContext);
        this.scheduledExecutorService = siddhiAppContext.getScheduledExecutorService();
    }

    public abstract void init(SourceEventListener var1, OptionHolder var2, String[] var3, ConfigReader var4, SiddhiAppContext var5);

    public abstract Class[] getOutputEventClasses();

    public abstract void connect(ConnectionCallback var1) throws ConnectionUnavailableException;

    public abstract void disconnect();

    public abstract void destroy();

    public abstract void pause();

    public abstract void resume();

    public void connectWithRetry() {
        if (!this.isConnected.get()) {
            this.isTryingToConnect.set(true);
            try {
                this.connect(this.connectionCallback);
                this.isConnected.set(true);
                this.isTryingToConnect.set(false);
                this.backoffRetryCounter.reset();
            }
            catch (ConnectionUnavailableException e) {
                LOG.error((Object)(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext) + " Error while connecting at Source '" + this.type + "' at '" + this.streamDefinition.getId() + "'. Will retry in '" + this.backoffRetryCounter.getTimeInterval() + "'."), (Throwable)e);
                this.scheduledExecutorService.schedule(new Runnable(){

                    @Override
                    public void run() {
                        Source.this.connectWithRetry();
                    }
                }, this.backoffRetryCounter.getTimeIntervalMillis(), TimeUnit.MILLISECONDS);
                this.backoffRetryCounter.increment();
            }
            catch (RuntimeException e) {
                LOG.error((Object)(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext) + "Error while connecting at Source '" + this.type + "' at '" + this.streamDefinition.getId() + "'."), (Throwable)e);
                throw e;
            }
        }
    }

    public final SourceMapper getMapper() {
        return this.mapper;
    }

    public void shutdown() {
        try {
            this.disconnect();
            this.destroy();
        }
        finally {
            this.isConnected.set(false);
            this.isTryingToConnect.set(false);
        }
    }

    @Override
    public final String getElementId() {
        return this.elementId;
    }

    public String getType() {
        return this.type;
    }

    public StreamDefinition getStreamDefinition() {
        return this.streamDefinition;
    }

    public class ConnectionCallback {
        public void onError(ConnectionUnavailableException e) {
            Source.this.disconnect();
            Source.this.isConnected.set(false);
            LOG.error((Object)(ExceptionUtil.getMessageWithContext(e, Source.this.siddhiAppContext) + " Connection unavailable at Sink '" + Source.this.type + "' at '" + Source.this.streamDefinition.getId() + "', will retry connection immediately."), (Throwable)e);
            Source.this.connectWithRetry();
        }
    }
}

