/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.stream.input.source;

import java.util.List;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.stream.input.InputHandler;
import org.wso2.siddhi.core.stream.input.source.AttributeMapping;
import org.wso2.siddhi.core.util.ExceptionUtil;

public class InputEventHandler {
    private static final Logger LOG = Logger.getLogger(InputEventHandler.class);
    private final ThreadLocal<String[]> trpProperties;
    private String sourceType;
    private SiddhiAppContext siddhiAppContext;
    private InputHandler inputHandler;
    private List<AttributeMapping> transportMapping;

    InputEventHandler(InputHandler inputHandler, List<AttributeMapping> transportMapping, ThreadLocal<String[]> trpProperties, String sourceType, SiddhiAppContext siddhiAppContext) {
        this.inputHandler = inputHandler;
        this.transportMapping = transportMapping;
        this.trpProperties = trpProperties;
        this.sourceType = sourceType;
        this.siddhiAppContext = siddhiAppContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEvent(Event event) throws InterruptedException {
        try {
            String[] transportProperties = this.trpProperties.get();
            this.trpProperties.remove();
            for (int i = 0; i < this.transportMapping.size(); ++i) {
                AttributeMapping attributeMapping = this.transportMapping.get(i);
                event.getData()[attributeMapping.getPosition()] = transportProperties[i];
            }
            this.inputHandler.send(event);
        }
        catch (RuntimeException e) {
            LOG.error((Object)(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext) + " Error in applying transport property mapping for '" + this.sourceType + "' source at '" + this.inputHandler.getStreamId() + "' stream."), (Throwable)e);
        }
        finally {
            this.trpProperties.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEvents(Event[] events) throws InterruptedException {
        try {
            String[] transportProperties = this.trpProperties.get();
            for (int i = 0; i < this.transportMapping.size(); ++i) {
                AttributeMapping attributeMapping = this.transportMapping.get(i);
                for (Event event : events) {
                    event.getData()[attributeMapping.getPosition()] = transportProperties[i];
                }
            }
            this.inputHandler.send(events);
        }
        catch (RuntimeException e) {
            LOG.error((Object)(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext) + " Error in applying transport property mapping for '" + this.sourceType + "' source at '" + this.inputHandler.getStreamId() + "' stream."), (Throwable)e);
        }
        finally {
            this.trpProperties.remove();
        }
    }
}

