/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.input;

import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.query.input.MultiProcessStreamReceiver;
import org.wso2.siddhi.core.query.input.stream.state.StreamPreStateProcessor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.selector.QuerySelector;
import org.wso2.siddhi.core.util.statistics.LatencyTracker;

public class StateMultiProcessStreamReceiver
extends MultiProcessStreamReceiver {
    private QuerySelector querySelector;

    public StateMultiProcessStreamReceiver(String streamId, int processCount, LatencyTracker latencyTracker, String queryName) {
        super(streamId, processCount, latencyTracker, queryName);
    }

    @Override
    public void setNext(Processor next) {
        super.setNext(next);
        this.querySelector = (QuerySelector)((StreamPreStateProcessor)next).getThisStatePostProcessor().getNextProcessor();
    }

    @Override
    public StateMultiProcessStreamReceiver clone(String key) {
        return new StateMultiProcessStreamReceiver(this.streamId + key, this.processCount, this.latencyTracker, this.queryName);
    }

    @Override
    protected void processAndClear(int processIndex, StreamEvent streamEvent) {
        ComplexEventChunk<StateEvent> retEventChunk = new ComplexEventChunk<StateEvent>(this.batchProcessingAllowed);
        ComplexEventChunk<StreamEvent> currentStreamEventChunk = new ComplexEventChunk<StreamEvent>(streamEvent, streamEvent, this.batchProcessingAllowed);
        ComplexEventChunk<StateEvent> eventChunk = ((StreamPreStateProcessor)this.nextProcessors[processIndex]).processAndReturn(currentStreamEventChunk);
        if (eventChunk.getFirst() != null) {
            retEventChunk.add(eventChunk.getFirst());
        }
        eventChunk.clear();
        if (this.querySelector != null) {
            while (retEventChunk.hasNext()) {
                StateEvent stateEvent = (StateEvent)retEventChunk.next();
                retEventChunk.remove();
                this.querySelector.process(new ComplexEventChunk<StateEvent>(stateEvent, stateEvent, this.batchProcessingAllowed));
            }
        }
    }
}

