/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.aggregation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.MetaStateEvent;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.exception.SiddhiAppCreationException;
import org.wso2.siddhi.core.exception.SiddhiAppRuntimeException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.query.input.stream.single.EntryValveExecutor;
import org.wso2.siddhi.core.query.input.stream.single.SingleStreamRuntime;
import org.wso2.siddhi.core.query.selector.attribute.aggregator.incremental.IncrementalExecutor;
import org.wso2.siddhi.core.table.Table;
import org.wso2.siddhi.core.util.collection.operator.CompiledCondition;
import org.wso2.siddhi.core.util.collection.operator.IncrementalAggregateCompileCondition;
import org.wso2.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import org.wso2.siddhi.core.util.collection.operator.Operator;
import org.wso2.siddhi.core.util.parser.ExpressionParser;
import org.wso2.siddhi.core.util.parser.MatcherParser;
import org.wso2.siddhi.core.util.parser.OperatorParser;
import org.wso2.siddhi.query.api.aggregation.TimePeriod;
import org.wso2.siddhi.query.api.aggregation.Within;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.AggregationDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.definition.TableDefinition;
import org.wso2.siddhi.query.api.expression.AttributeFunction;
import org.wso2.siddhi.query.api.expression.Expression;

public class AggregationRuntime {
    private final AggregationDefinition aggregationDefinition;
    private final Map<TimePeriod.Duration, IncrementalExecutor> incrementalExecutorMap;
    private final Map<TimePeriod.Duration, Table> aggregationTables;
    private final SiddhiAppContext siddhiAppContext;
    private final MetaStreamEvent tableMetaStreamEvent;
    private final MetaStreamEvent aggregateMetaSteamEvent;
    private List<TimePeriod.Duration> incrementalDurations;
    private SingleStreamRuntime singleStreamRuntime;
    private EntryValveExecutor entryValveExecutor;
    private ExpressionExecutor perExpressionExecutor;
    private List<ExpressionExecutor> baseExecutors;
    private ExpressionExecutor timestampExecutor;
    private List<ExpressionExecutor> outputExpressionExecutors;

    public AggregationRuntime(AggregationDefinition aggregationDefinition, Map<TimePeriod.Duration, IncrementalExecutor> incrementalExecutorMap, Map<TimePeriod.Duration, Table> aggregationTables, SingleStreamRuntime singleStreamRuntime, EntryValveExecutor entryValveExecutor, List<TimePeriod.Duration> incrementalDurations, SiddhiAppContext siddhiAppContext, List<ExpressionExecutor> baseExecutors, ExpressionExecutor timestampExecutor, MetaStreamEvent tableMetaStreamEvent, List<ExpressionExecutor> outputExpressionExecutors) {
        this.aggregationDefinition = aggregationDefinition;
        this.incrementalExecutorMap = incrementalExecutorMap;
        this.aggregationTables = aggregationTables;
        this.incrementalDurations = incrementalDurations;
        this.siddhiAppContext = siddhiAppContext;
        this.singleStreamRuntime = singleStreamRuntime;
        this.entryValveExecutor = entryValveExecutor;
        this.baseExecutors = baseExecutors;
        this.timestampExecutor = timestampExecutor;
        this.tableMetaStreamEvent = tableMetaStreamEvent;
        this.outputExpressionExecutors = outputExpressionExecutors;
        this.aggregateMetaSteamEvent = new MetaStreamEvent();
        aggregationDefinition.getAttributeList().forEach(this.aggregateMetaSteamEvent::addOutputData);
    }

    private static MatchingMetaInfoHolder aggregationTableMetaInfoHolder(MatchingMetaInfoHolder matchingMetaInfoHolder, AbstractDefinition tableDefinition) {
        MetaStreamEvent metaStreamEventForTable = new MetaStreamEvent();
        metaStreamEventForTable.setEventType(MetaStreamEvent.EventType.TABLE);
        metaStreamEventForTable.addInputDefinition(tableDefinition);
        if (matchingMetaInfoHolder.getMetaStateEvent().getMetaStreamEvents().length == 1) {
            MetaStateEvent metaStateEvent = new MetaStateEvent(1);
            metaStateEvent.addEvent(metaStreamEventForTable);
            return new MatchingMetaInfoHolder(metaStateEvent, 0, 0, tableDefinition, tableDefinition, 0);
        }
        MetaStateEvent metaStateEvent = new MetaStateEvent(2);
        metaStateEvent.addEvent(matchingMetaInfoHolder.getMetaStateEvent().getMetaStreamEvent(matchingMetaInfoHolder.getMatchingStreamEventIndex()));
        metaStateEvent.addEvent(metaStreamEventForTable);
        return MatcherParser.constructMatchingMetaStateHolder(metaStateEvent, 0, tableDefinition, -1);
    }

    public Map<TimePeriod.Duration, IncrementalExecutor> getIncrementalExecutorMap() {
        return this.incrementalExecutorMap;
    }

    public Map<TimePeriod.Duration, Table> getAggregationTables() {
        return this.aggregationTables;
    }

    public AggregationDefinition getAggregationDefinition() {
        return this.aggregationDefinition;
    }

    public SiddhiAppContext getSiddhiAppContext() {
        return this.siddhiAppContext;
    }

    public SingleStreamRuntime getSingleStreamRuntime() {
        return this.singleStreamRuntime;
    }

    public EntryValveExecutor getEntryValveExecutor() {
        return this.entryValveExecutor;
    }

    public List<TimePeriod.Duration> getIncrementalDurations() {
        return this.incrementalDurations;
    }

    public StreamEvent find(StateEvent matchingEvent, CompiledCondition compiledCondition) {
        String perValueAsString = this.perExpressionExecutor.execute(matchingEvent).toString();
        TimePeriod.Duration perValue = TimePeriod.Duration.valueOf((String)perValueAsString.toUpperCase());
        if (!this.incrementalExecutorMap.keySet().contains(perValue)) {
            throw new SiddhiAppRuntimeException("The aggregate values for " + perValue.toString() + " granularity cannot be provided since aggregation definition " + this.aggregationDefinition.getId() + " does not contain " + perValue.toString() + " duration");
        }
        Table tableForPerDuration = this.aggregationTables.get(perValue);
        return ((IncrementalAggregateCompileCondition)compiledCondition).find(matchingEvent, perValue, this.incrementalExecutorMap, this.incrementalDurations, tableForPerDuration, this.baseExecutors, this.timestampExecutor, this.outputExpressionExecutors);
    }

    public CompiledCondition compileExpression(Expression expression, Within within, Expression per, MatchingMetaInfoHolder matchingMetaInfoHolder, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, String queryName, SiddhiAppContext siddhiAppContext) {
        HashMap<TimePeriod.Duration, CompiledCondition> withinTableCompiledConditions = new HashMap<TimePeriod.Duration, CompiledCondition>();
        this.perExpressionExecutor = ExpressionParser.parseExpression(per, matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, siddhiAppContext, false, 0, queryName);
        if (this.perExpressionExecutor.getReturnType() != Attribute.Type.STRING) {
            throw new SiddhiAppCreationException("Query " + queryName + "'s per value expected a string but found " + this.perExpressionExecutor.getReturnType(), per.getQueryContextStartIndex(), per.getQueryContextEndIndex());
        }
        AttributeFunction withinExpression = within.getTimeRange().size() == 1 ? new AttributeFunction("incrementalAggregator", "within", new Expression[]{(Expression)within.getTimeRange().get(0), Expression.variable((String)"_TIMESTAMP")}) : new AttributeFunction("incrementalAggregator", "within", new Expression[]{(Expression)within.getTimeRange().get(0), (Expression)within.getTimeRange().get(1), Expression.variable((String)"_TIMESTAMP")});
        TableDefinition tableDefinition = ((Table)this.aggregationTables.values().toArray()[0]).getTableDefinition();
        for (Map.Entry<TimePeriod.Duration, Table> entry : this.aggregationTables.entrySet()) {
            CompiledCondition withinTableCompileCondition = entry.getValue().compileCondition((Expression)withinExpression, AggregationRuntime.aggregationTableMetaInfoHolder(matchingMetaInfoHolder, (AbstractDefinition)tableDefinition), siddhiAppContext, variableExpressionExecutors, tableMap, queryName);
            withinTableCompiledConditions.put(entry.getKey(), withinTableCompileCondition);
        }
        Operator withinInMemoryCompileCondition = OperatorParser.constructOperator(new ComplexEventChunk(true), (Expression)withinExpression, AggregationRuntime.aggregationTableMetaInfoHolder(matchingMetaInfoHolder, (AbstractDefinition)tableDefinition), siddhiAppContext, variableExpressionExecutors, tableMap, queryName);
        Operator onCompiledCondition = OperatorParser.constructOperator(new ComplexEventChunk(true), expression, matchingMetaInfoHolder, siddhiAppContext, variableExpressionExecutors, tableMap, queryName);
        return new IncrementalAggregateCompileCondition(withinTableCompiledConditions, withinInMemoryCompileCondition, onCompiledCondition, this.tableMetaStreamEvent, this.aggregateMetaSteamEvent);
    }
}

