/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.persistence;

import org.apache.log4j.Logger;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.exception.NoPersistenceStoreException;
import org.wso2.siddhi.core.util.persistence.PersistenceStore;
import org.wso2.siddhi.core.util.snapshot.SnapshotService;

public class PersistenceService {
    private static final Logger log = Logger.getLogger(PersistenceService.class);
    private String siddhiAppName;
    private PersistenceStore persistenceStore;
    private SnapshotService snapshotService;

    public PersistenceService(SiddhiAppContext siddhiAppContext) {
        this.snapshotService = siddhiAppContext.getSnapshotService();
        this.persistenceStore = siddhiAppContext.getSiddhiContext().getPersistenceStore();
        this.siddhiAppName = siddhiAppContext.getName();
    }

    public String persist() {
        if (this.persistenceStore != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Persisting...");
            }
            byte[] snapshot = this.snapshotService.snapshot();
            String revision = System.currentTimeMillis() + "_" + this.siddhiAppName;
            this.persistenceStore.save(this.siddhiAppName, revision, snapshot);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Persisted.");
            }
            return revision;
        }
        throw new NoPersistenceStoreException("No persistence store assigned for siddhi app " + this.siddhiAppName);
    }

    public void restoreRevision(String revision) {
        if (this.persistenceStore != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Restoring revision: " + revision + " ..."));
            }
            byte[] snapshot = this.persistenceStore.load(this.siddhiAppName, revision);
            this.snapshotService.restore(snapshot);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Restored revision: " + revision));
            }
        } else {
            throw new NoPersistenceStoreException("No persistence store assigned for siddhi app " + this.siddhiAppName);
        }
    }

    public String restoreLastRevision() {
        if (this.persistenceStore != null) {
            String revision = this.persistenceStore.getLastRevision(this.siddhiAppName);
            if (revision != null) {
                this.restoreRevision(revision);
            }
            return revision;
        }
        throw new NoPersistenceStoreException("No persistence store assigned for siddhi app " + this.siddhiAppName);
    }

    public void restore(byte[] snapshot) {
        this.snapshotService.restore(snapshot);
    }
}

