/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.selector.attribute.aggregator.incremental;

import java.util.ArrayList;
import java.util.List;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.executor.ExpressionExecutor;

public class BaseIncrementalValueStore {
    private long timestamp;
    private Object[] values;
    private List<ExpressionExecutor> expressionExecutors;
    private boolean isProcessed = false;
    private StreamEventPool streamEventPool;

    public BaseIncrementalValueStore(long timeStamp, List<ExpressionExecutor> expressionExecutors, StreamEventPool streamEventPool) {
        this.timestamp = timeStamp;
        this.values = new Object[expressionExecutors.size() + 1];
        this.expressionExecutors = expressionExecutors;
        this.streamEventPool = streamEventPool;
    }

    public void clearValues() {
        this.values = new Object[this.expressionExecutors.size() + 1];
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setValue(Object value, int position) {
        this.values[position] = value;
    }

    public void setProcessed(boolean isProcessed) {
        this.isProcessed = isProcessed;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Object[] getValues() {
        return this.values;
    }

    public List<ExpressionExecutor> getExpressionExecutors() {
        return this.expressionExecutors;
    }

    public boolean isProcessed() {
        return this.isProcessed;
    }

    public StreamEvent createStreamEvent() {
        StreamEvent streamEvent = this.streamEventPool.borrowEvent();
        streamEvent.setTimestamp(this.timestamp);
        this.setValue(this.timestamp, 0);
        streamEvent.setOutputData(this.values);
        return streamEvent;
    }

    public BaseIncrementalValueStore cloneStore(String key, long timestamp) {
        ArrayList<ExpressionExecutor> newExpressionExecutors = new ArrayList<ExpressionExecutor>(this.expressionExecutors.size());
        this.expressionExecutors.forEach(expressionExecutor -> newExpressionExecutors.add(expressionExecutor.cloneExecutor(key)));
        return new BaseIncrementalValueStore(timestamp, newExpressionExecutors, this.streamEventPool);
    }
}

