/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.statistics.metrics;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reporter;
import com.codahale.metrics.ScheduledReporter;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.wso2.siddhi.core.util.statistics.StatisticsManager;
import org.wso2.siddhi.query.api.annotation.Element;

public class SiddhiStatisticsManager
implements StatisticsManager {
    private MetricRegistry metricRegistry = new MetricRegistry();
    private Reporter reporter;
    private String reporterName = "console";
    private int interval = 60;

    public SiddhiStatisticsManager(List<Element> elements) {
        for (Element element : elements) {
            if ("reporter".equals(element.getKey())) {
                this.reporterName = element.getValue();
                continue;
            }
            if (!"interval".equals(element.getKey())) continue;
            this.interval = Integer.parseInt(element.getValue());
        }
    }

    @Override
    public MetricRegistry getRegistry() {
        return this.metricRegistry;
    }

    @Override
    public void startReporting() {
        if (this.reporterName.equalsIgnoreCase("console")) {
            this.reporter = ConsoleReporter.forRegistry((MetricRegistry)this.metricRegistry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
            ((ConsoleReporter)this.reporter).start((long)this.interval, TimeUnit.SECONDS);
        } else if (this.reporterName.equalsIgnoreCase("jmx")) {
            this.reporter = JmxReporter.forRegistry((MetricRegistry)this.metricRegistry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
            ((JmxReporter)this.reporter).start();
        } else {
            throw new UnsupportedOperationException("Only 'ConsoleReporter' and 'JmxReporter' is supported, Reporter type '" + this.reporter.getClass().getName() + "' is not supported");
        }
    }

    @Override
    public void stopReporting() {
        if (this.reporter instanceof ScheduledReporter) {
            ((ScheduledReporter)this.reporter).stop();
        } else if (this.reporter instanceof JmxReporter) {
            ((JmxReporter)this.reporter).stop();
        } else {
            throw new UnsupportedOperationException("Only 'ConsoleReporter' and 'JmxReporter' is supported, Reporter type '" + this.reporter.getClass().getName() + "' is not supported");
        }
    }

    @Override
    public void cleanup() {
    }
}

