/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.snapshot;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ByteSerializer {
    private static final Log log = LogFactory.getLog(ByteSerializer.class);

    private ByteSerializer() {
    }

    public static byte[] OToB(Object obj) {
        long start = System.currentTimeMillis();
        byte[] out = null;
        if (obj != null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(obj);
                out = baos.toByteArray();
            }
            catch (IOException e) {
                log.error((Object)("Error when writing byte array. " + e.getMessage()), (Throwable)e);
                return null;
            }
        }
        long end = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Encoded in :" + (end - start) + " msec"));
        }
        return out;
    }

    public static Object BToO(byte[] bytes) {
        long start = System.currentTimeMillis();
        Object out = null;
        if (bytes != null) {
            try {
                ByteArrayInputStream bios = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bios);
                out = ois.readObject();
            }
            catch (IOException e) {
                log.error((Object)("Error when writing to object. " + e.getMessage()), (Throwable)e);
                return null;
            }
            catch (ClassNotFoundException e) {
                log.error((Object)("Error when writing to object. " + e.getMessage()), (Throwable)e);
                return null;
            }
        }
        long end = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Decoded in :" + (end - start) + " msec"));
        }
        return out;
    }
}

