/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.persistence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.siddhi.core.util.persistence.PersistenceStore;

public class InMemoryPersistenceStore
implements PersistenceStore {
    private static final Log log = LogFactory.getLog(InMemoryPersistenceStore.class);
    Map<String, Map<String, byte[]>> persistenceMap = new HashMap<String, Map<String, byte[]>>();
    Map<String, List<String>> revisionMap = new HashMap<String, List<String>>();

    @Override
    public void save(String executionPlanId, String revision, byte[] data) {
        Map<String, byte[]> executionPersistenceMap = this.persistenceMap.get(executionPlanId);
        if (executionPersistenceMap == null) {
            executionPersistenceMap = new HashMap<String, byte[]>();
        }
        executionPersistenceMap.put(revision, data);
        List<String> revisionList = this.revisionMap.get(executionPlanId);
        if (revisionList == null) {
            revisionList = new ArrayList<String>();
            this.revisionMap.put(executionPlanId, revisionList);
        }
        if (revisionList.size() == 0 || revisionList.size() > 0 && !revision.equals(revisionList.get(revisionList.size() - 1))) {
            revisionList.add(revision);
            this.revisionMap.put(executionPlanId, revisionList);
        }
        this.persistenceMap.put(executionPlanId, executionPersistenceMap);
    }

    @Override
    public byte[] load(String executionPlanId, String revision) {
        Map<String, byte[]> executionPersistenceMap = this.persistenceMap.get(executionPlanId);
        if (executionPersistenceMap == null) {
            log.warn((Object)("Data not found for the execution plan " + executionPlanId));
            return null;
        }
        return executionPersistenceMap.get(revision);
    }

    @Override
    public String getLastRevision(String executionPlanIdentifier) {
        List<String> revisionList = this.revisionMap.get(executionPlanIdentifier);
        if (revisionList == null) {
            return null;
        }
        if (revisionList.size() > 0) {
            return revisionList.get(revisionList.size() - 1);
        }
        return null;
    }

    @Override
    public void setProperties(Map properties) {
    }

    public void shutdown() {
        this.persistenceMap.clear();
        this.revisionMap.clear();
    }
}

