/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.parser;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.config.SiddhiContext;
import org.wso2.siddhi.core.exception.ExecutionPlanCreationException;
import org.wso2.siddhi.core.partition.PartitionRuntime;
import org.wso2.siddhi.core.query.QueryRuntime;
import org.wso2.siddhi.core.util.ElementIdGenerator;
import org.wso2.siddhi.core.util.ExecutionPlanRuntimeBuilder;
import org.wso2.siddhi.core.util.ThreadBarrier;
import org.wso2.siddhi.core.util.parser.PartitionParser;
import org.wso2.siddhi.core.util.parser.QueryParser;
import org.wso2.siddhi.core.util.persistence.PersistenceService;
import org.wso2.siddhi.core.util.snapshot.SnapshotService;
import org.wso2.siddhi.core.util.statistics.LatencyTracker;
import org.wso2.siddhi.core.util.timestamp.EventTimeBasedMillisTimestampGenerator;
import org.wso2.siddhi.core.util.timestamp.SystemCurrentTimeMillisTimestampGenerator;
import org.wso2.siddhi.core.window.EventWindow;
import org.wso2.siddhi.query.api.ExecutionPlan;
import org.wso2.siddhi.query.api.annotation.Element;
import org.wso2.siddhi.query.api.definition.FunctionDefinition;
import org.wso2.siddhi.query.api.definition.StreamDefinition;
import org.wso2.siddhi.query.api.definition.TableDefinition;
import org.wso2.siddhi.query.api.definition.TriggerDefinition;
import org.wso2.siddhi.query.api.definition.WindowDefinition;
import org.wso2.siddhi.query.api.exception.DuplicateAnnotationException;
import org.wso2.siddhi.query.api.exception.DuplicateDefinitionException;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;
import org.wso2.siddhi.query.api.execution.ExecutionElement;
import org.wso2.siddhi.query.api.execution.partition.Partition;
import org.wso2.siddhi.query.api.execution.query.Query;
import org.wso2.siddhi.query.api.util.AnnotationHelper;
import org.wso2.siddhi.query.compiler.SiddhiCompiler;
import org.wso2.siddhi.query.compiler.exception.SiddhiParserException;

public class ExecutionPlanParser {
    private static final Log log = LogFactory.getLog(ExecutionPlanRuntimeBuilder.class);

    public static ExecutionPlanRuntimeBuilder parse(ExecutionPlan executionPlan, SiddhiContext siddhiContext) {
        ExecutionPlanContext executionPlanContext = new ExecutionPlanContext();
        executionPlanContext.setSiddhiContext(siddhiContext);
        try {
            String interval;
            Element element = AnnotationHelper.getAnnotationElement((String)"Name", null, (List)executionPlan.getAnnotations());
            if (element != null) {
                executionPlanContext.setName(element.getValue());
            } else {
                executionPlanContext.setName(UUID.randomUUID().toString());
            }
            Object annotation = AnnotationHelper.getAnnotation((String)"EnforceOrder", (List)executionPlan.getAnnotations());
            if (annotation != null) {
                executionPlanContext.setEnforceOrder(true);
            }
            if ((annotation = AnnotationHelper.getAnnotation((String)"Async", (List)executionPlan.getAnnotations())) != null) {
                executionPlanContext.setAsync(true);
                String bufferSizeString = annotation.getElement("BufferSize");
                if (bufferSizeString != null) {
                    int bufferSize = Integer.parseInt(bufferSizeString);
                    executionPlanContext.setBufferSize(bufferSize);
                } else {
                    executionPlanContext.setBufferSize(1024);
                }
            }
            if ((annotation = AnnotationHelper.getAnnotation((String)"CleanAggregators", (List)executionPlan.getAnnotations())) != null && (interval = annotation.getElement("interval")) != null) {
                int value = Integer.parseInt(interval);
                executionPlanContext.setCleanAggregators(value > 0);
                executionPlanContext.setCleanAggregatorInterval(value);
            }
            annotation = AnnotationHelper.getAnnotation((String)"Statistics", (List)executionPlan.getAnnotations());
            Element statElement = AnnotationHelper.getAnnotationElement((String)"Statistics", null, (List)executionPlan.getAnnotations());
            if (annotation != null && (statElement == null || Boolean.valueOf(statElement.getValue()).booleanValue()) && siddhiContext.getStatisticsConfiguration() != null) {
                executionPlanContext.setStatsEnabled(true);
                executionPlanContext.setStatisticsManager(siddhiContext.getStatisticsConfiguration().getFactory().createStatisticsManager(annotation.getElements()));
            }
            executionPlanContext.setThreadBarrier(new ThreadBarrier());
            executionPlanContext.setExecutorService(Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("Siddhi-" + executionPlanContext.getName() + "-executor-thread-%d").build()));
            executionPlanContext.setScheduledExecutorService(Executors.newScheduledThreadPool(5, new ThreadFactoryBuilder().setNameFormat("Siddhi-" + executionPlanContext.getName() + "-scheduler-thread-%d").build()));
            annotation = AnnotationHelper.getAnnotation((String)"Playback", (List)executionPlan.getAnnotations());
            if (annotation != null) {
                String idleTime = null;
                String increment = null;
                EventTimeBasedMillisTimestampGenerator timestampGenerator = new EventTimeBasedMillisTimestampGenerator(executionPlanContext.getScheduledExecutorService());
                for (Element e : annotation.getElements()) {
                    if ("IdleTime".equalsIgnoreCase(e.getKey())) {
                        idleTime = e.getValue();
                        continue;
                    }
                    if ("Increment".equalsIgnoreCase(e.getKey())) {
                        increment = e.getValue();
                        continue;
                    }
                    throw new ExecutionPlanValidationException("Playback annotation accepts only idleTime and increment but found " + e.getKey());
                }
                if (idleTime != null && increment == null) {
                    throw new ExecutionPlanValidationException("Playback annotation requires both idleTime and increment but increment not found");
                }
                if (idleTime == null && increment != null) {
                    throw new ExecutionPlanValidationException("Playback annotation requires both idleTime and increment but idleTime does not found");
                }
                if (idleTime != null) {
                    try {
                        timestampGenerator.setIdleTime(SiddhiCompiler.parseTimeConstantDefinition(idleTime).value());
                    }
                    catch (SiddhiParserException ex) {
                        throw new SiddhiParserException("Invalid idleTime constant '" + idleTime + "' in playback annotation", (Throwable)ex);
                    }
                    try {
                        timestampGenerator.setIncrementInMilliseconds(SiddhiCompiler.parseTimeConstantDefinition((String)increment).value());
                    }
                    catch (SiddhiParserException ex) {
                        throw new SiddhiParserException("Invalid increment constant '" + increment + "' in playback annotation", (Throwable)ex);
                    }
                }
                executionPlanContext.setTimestampGenerator(timestampGenerator);
                executionPlanContext.setPlayback(true);
            } else {
                executionPlanContext.setTimestampGenerator(new SystemCurrentTimeMillisTimestampGenerator());
            }
            executionPlanContext.setSnapshotService(new SnapshotService(executionPlanContext));
            executionPlanContext.setPersistenceService(new PersistenceService(executionPlanContext));
            executionPlanContext.setElementIdGenerator(new ElementIdGenerator(executionPlanContext.getName()));
        }
        catch (DuplicateAnnotationException e) {
            throw new DuplicateAnnotationException(e.getMessage() + " for the same Execution Plan " + executionPlan.toString());
        }
        ExecutionPlanRuntimeBuilder executionPlanRuntimeBuilder = new ExecutionPlanRuntimeBuilder(executionPlanContext);
        ExecutionPlanParser.defineStreamDefinitions(executionPlanRuntimeBuilder, executionPlan.getStreamDefinitionMap());
        ExecutionPlanParser.defineTableDefinitions(executionPlanRuntimeBuilder, executionPlan.getTableDefinitionMap());
        ExecutionPlanParser.defineWindowDefinitions(executionPlanRuntimeBuilder, executionPlan.getWindowDefinitionMap());
        ExecutionPlanParser.defineFunctionDefinitions(executionPlanRuntimeBuilder, executionPlan.getFunctionDefinitionMap());
        for (EventWindow eventWindow : executionPlanRuntimeBuilder.getEventWindowMap().values()) {
            String metricName = executionPlanContext.getSiddhiContext().getStatisticsConfiguration().getMatricPrefix() + "." + "ExecutionPlans" + "." + executionPlanContext.getName() + "." + "Siddhi" + "." + "Windows" + "." + eventWindow.getWindowDefinition().getId();
            LatencyTracker latencyTracker = null;
            if (executionPlanContext.isStatsEnabled() && executionPlanContext.getStatisticsManager() != null) {
                latencyTracker = executionPlanContext.getSiddhiContext().getStatisticsConfiguration().getFactory().createLatencyTracker(metricName, executionPlanContext.getStatisticsManager());
            }
            eventWindow.init(executionPlanRuntimeBuilder.getEventTableMap(), executionPlanRuntimeBuilder.getEventWindowMap(), latencyTracker, eventWindow.getWindowDefinition().getId());
        }
        try {
            for (ExecutionElement executionElement : executionPlan.getExecutionElementList()) {
                if (executionElement instanceof Query) {
                    QueryRuntime queryRuntime = QueryParser.parse((Query)executionElement, executionPlanContext, executionPlanRuntimeBuilder.getStreamDefinitionMap(), executionPlanRuntimeBuilder.getTableDefinitionMap(), executionPlanRuntimeBuilder.getWindowDefinitionMap(), executionPlanRuntimeBuilder.getEventTableMap(), executionPlanRuntimeBuilder.getEventWindowMap(), executionPlanRuntimeBuilder.getLockSynchronizer());
                    executionPlanRuntimeBuilder.addQuery(queryRuntime);
                    continue;
                }
                PartitionRuntime partitionRuntime = PartitionParser.parse(executionPlanRuntimeBuilder, (Partition)executionElement, executionPlanContext, executionPlanRuntimeBuilder.getStreamDefinitionMap());
                executionPlanRuntimeBuilder.addPartition(partitionRuntime);
            }
        }
        catch (ExecutionPlanCreationException e) {
            throw new ExecutionPlanValidationException(e.getMessage() + " in execution plan \"" + executionPlanContext.getName() + "\"", (Throwable)e);
        }
        catch (DuplicateDefinitionException e) {
            throw new DuplicateDefinitionException(e.getMessage() + " in execution plan \"" + executionPlanContext.getName() + "\"", (Throwable)e);
        }
        ExecutionPlanParser.defineTriggerDefinitions(executionPlanRuntimeBuilder, executionPlan.getTriggerDefinitionMap());
        return executionPlanRuntimeBuilder;
    }

    private static void defineTriggerDefinitions(ExecutionPlanRuntimeBuilder executionPlanRuntimeBuilder, Map<String, TriggerDefinition> triggerDefinitionMap) {
        for (TriggerDefinition definition : triggerDefinitionMap.values()) {
            executionPlanRuntimeBuilder.defineTrigger(definition);
        }
    }

    private static void defineFunctionDefinitions(ExecutionPlanRuntimeBuilder executionPlanRuntimeBuilder, Map<String, FunctionDefinition> functionDefinitionMap) {
        for (FunctionDefinition definition : functionDefinitionMap.values()) {
            executionPlanRuntimeBuilder.defineFunction(definition);
        }
    }

    private static void defineStreamDefinitions(ExecutionPlanRuntimeBuilder executionPlanRuntimeBuilder, Map<String, StreamDefinition> streamDefinitionMap) {
        for (StreamDefinition definition : streamDefinitionMap.values()) {
            executionPlanRuntimeBuilder.defineStream(definition);
        }
    }

    private static void defineTableDefinitions(ExecutionPlanRuntimeBuilder executionPlanRuntimeBuilder, Map<String, TableDefinition> tableDefinitionMap) {
        for (TableDefinition definition : tableDefinitionMap.values()) {
            executionPlanRuntimeBuilder.defineTable(definition);
        }
    }

    private static void defineWindowDefinitions(ExecutionPlanRuntimeBuilder executionPlanRuntimeBuilder, Map<String, WindowDefinition> windowDefinitionMap) {
        for (WindowDefinition definition : windowDefinitionMap.values()) {
            executionPlanRuntimeBuilder.defineWindow(definition);
        }
    }
}

