/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.extension.holder;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.siddhi.core.config.ExecutionPlanContext;

public abstract class AbstractExtensionHolder {
    private static final String EXTENSION_SEPARATOR = ":";
    private static final Log log = LogFactory.getLog(AbstractExtensionHolder.class);
    protected Map<String, Class> extensionMap = new HashMap<String, Class>();

    protected AbstractExtensionHolder(Class clazz, ExecutionPlanContext executionPlanContext) {
        Map<String, Class> extensions = executionPlanContext.getSiddhiContext().getSiddhiExtensions();
        if (extensions != null) {
            for (String extensionKey : executionPlanContext.getSiddhiContext().getSiddhiExtensions().keySet()) {
                Class extension = extensions.get(extensionKey);
                if (!clazz.isAssignableFrom(extension)) continue;
                if (this.extensionMap.containsKey(extensionKey)) {
                    log.error((Object)("Extension class " + extension.getName() + " not loaded, as there is already an matching extension '" + extensionKey + "' implemented as " + this.extensionMap.get(extensionKey).getName()));
                    continue;
                }
                this.extensionMap.put(extensionKey, extension);
            }
        }
    }

    public Class getExtension(String namespace, String function) {
        String extensionKey = namespace + EXTENSION_SEPARATOR + function;
        return this.extensionMap.get(extensionKey);
    }
}

