/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.trigger;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.stream.StreamJunction;
import org.wso2.siddhi.core.trigger.EventTrigger;
import org.wso2.siddhi.query.api.definition.TriggerDefinition;

public class PeriodicEventTrigger
implements EventTrigger {
    private TriggerDefinition triggerDefinition;
    private ExecutionPlanContext executionPlanContext;
    private StreamJunction streamJunction;
    private ScheduledFuture scheduledFuture;

    @Override
    public void init(TriggerDefinition triggerDefinition, ExecutionPlanContext executionPlanContext, StreamJunction streamJunction) {
        this.triggerDefinition = triggerDefinition;
        this.executionPlanContext = executionPlanContext;
        this.streamJunction = streamJunction;
    }

    @Override
    public TriggerDefinition getTriggerDefinition() {
        return this.triggerDefinition;
    }

    @Override
    public String getId() {
        return this.triggerDefinition.getId();
    }

    @Override
    public void start() {
        this.scheduledFuture = this.executionPlanContext.getScheduledExecutorService().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                long currentTime = PeriodicEventTrigger.this.executionPlanContext.getTimestampGenerator().currentTime();
                PeriodicEventTrigger.this.streamJunction.sendEvent(new Event(currentTime, new Object[]{currentTime}));
            }
        }, this.triggerDefinition.getAtEvery(), this.triggerDefinition.getAtEvery(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
    }
}

