/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.table;

import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.table.EventTable;
import org.wso2.siddhi.core.table.holder.EventHolder;
import org.wso2.siddhi.core.util.collection.OverwritingStreamEventExtractor;
import org.wso2.siddhi.core.util.collection.UpdateAttributeMapper;
import org.wso2.siddhi.core.util.collection.operator.Finder;
import org.wso2.siddhi.core.util.collection.operator.MatchingMetaStateHolder;
import org.wso2.siddhi.core.util.collection.operator.Operator;
import org.wso2.siddhi.core.util.parser.EventHolderPasser;
import org.wso2.siddhi.core.util.parser.OperatorParser;
import org.wso2.siddhi.core.util.snapshot.Snapshotable;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.TableDefinition;
import org.wso2.siddhi.query.api.expression.Expression;

public class InMemoryEventTable
implements EventTable,
Snapshotable {
    private TableDefinition tableDefinition;
    private StreamEventCloner tableStreamEventCloner;
    private ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private EventHolder eventHolder;
    private String elementId;

    @Override
    public void init(TableDefinition tableDefinition, MetaStreamEvent tableMetaStreamEvent, StreamEventPool tableStreamEventPool, StreamEventCloner tableStreamEventCloner, ExecutionPlanContext executionPlanContext) {
        this.tableDefinition = tableDefinition;
        this.tableStreamEventCloner = tableStreamEventCloner;
        this.eventHolder = EventHolderPasser.parse((AbstractDefinition)tableDefinition, tableStreamEventPool);
        if (this.elementId == null) {
            this.elementId = "InMemoryEventTable" + executionPlanContext.getElementIdGenerator().createNewId();
        }
        executionPlanContext.getSnapshotService().addSnapshotable(tableDefinition.getId(), this);
    }

    @Override
    public TableDefinition getTableDefinition() {
        return this.tableDefinition;
    }

    @Override
    public void add(ComplexEventChunk<StreamEvent> addingEventChunk) {
        try {
            this.readWriteLock.writeLock().lock();
            this.eventHolder.add(addingEventChunk);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @Override
    public void delete(ComplexEventChunk<StateEvent> deletingEventChunk, Operator operator) {
        try {
            this.readWriteLock.writeLock().lock();
            operator.delete(deletingEventChunk, this.eventHolder);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(ComplexEventChunk<StateEvent> updatingEventChunk, Operator operator, UpdateAttributeMapper[] updateAttributeMappers) {
        try {
            this.readWriteLock.writeLock().lock();
            operator.update(updatingEventChunk, this.eventHolder, updateAttributeMappers);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overwriteOrAdd(ComplexEventChunk<StateEvent> overwritingOrAddingEventChunk, Operator operator, UpdateAttributeMapper[] updateAttributeMappers, OverwritingStreamEventExtractor overwritingStreamEventExtractor) {
        try {
            this.readWriteLock.writeLock().lock();
            ComplexEventChunk<StreamEvent> failedEvents = operator.overwriteOrAdd(overwritingOrAddingEventChunk, this.eventHolder, updateAttributeMappers, overwritingStreamEventExtractor);
            this.eventHolder.add(failedEvents);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(StateEvent matchingEvent, Finder finder) {
        try {
            this.readWriteLock.readLock().lock();
            boolean bl = finder.contains(matchingEvent, this.eventHolder);
            return bl;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StreamEvent find(StateEvent matchingEvent, Finder finder) {
        try {
            this.readWriteLock.readLock().lock();
            StreamEvent streamEvent = finder.find(matchingEvent, this.eventHolder, this.tableStreamEventCloner);
            return streamEvent;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    public Finder constructFinder(Expression expression, MatchingMetaStateHolder matchingMetaStateHolder, ExecutionPlanContext executionPlanContext, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, EventTable> eventTableMap) {
        return OperatorParser.constructOperator(this.eventHolder, expression, matchingMetaStateHolder, executionPlanContext, variableExpressionExecutors, eventTableMap, this.tableDefinition.getId());
    }

    @Override
    public Operator constructOperator(Expression expression, MatchingMetaStateHolder matchingMetaStateHolder, ExecutionPlanContext executionPlanContext, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, EventTable> eventTableMap) {
        return OperatorParser.constructOperator(this.eventHolder, expression, matchingMetaStateHolder, executionPlanContext, variableExpressionExecutors, eventTableMap, this.tableDefinition.getId());
    }

    @Override
    public Object[] currentState() {
        return new Object[]{new AbstractMap.SimpleEntry<String, EventHolder>("EventHolder", this.eventHolder)};
    }

    @Override
    public void restoreState(Object[] state) {
        Map.Entry stateEntry = (Map.Entry)state[0];
        this.eventHolder = (EventHolder)stateEntry.getValue();
    }

    @Override
    public String getElementId() {
        return this.elementId;
    }
}

