/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.selector.attribute.aggregator;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.exception.OperationNotSupportedException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.query.selector.attribute.aggregator.AttributeAggregator;
import org.wso2.siddhi.query.api.definition.Attribute;

public class StddevAttributeAggregator
extends AttributeAggregator {
    private StddevAttributeAggregator stddevOutputAttributeAggregator;

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new OperationNotSupportedException("Stddev aggregator has to have exactly 1 parameter, currently " + attributeExpressionExecutors.length + " parameters provided");
        }
        Attribute.Type type = attributeExpressionExecutors[0].getReturnType();
        switch (type) {
            case INT: {
                this.stddevOutputAttributeAggregator = new StddevAttributeAggregatorInt();
                break;
            }
            case LONG: {
                this.stddevOutputAttributeAggregator = new StddevAttributeAggregatorLong();
                break;
            }
            case FLOAT: {
                this.stddevOutputAttributeAggregator = new StddevAttributeAggregatorFloat();
                break;
            }
            case DOUBLE: {
                this.stddevOutputAttributeAggregator = new StddevAttributeAggregatorDouble();
                break;
            }
            default: {
                throw new OperationNotSupportedException("Stddev not supported for " + type);
            }
        }
    }

    @Override
    public Attribute.Type getReturnType() {
        return this.stddevOutputAttributeAggregator.getReturnType();
    }

    @Override
    public Object processAdd(Object data) {
        return this.stddevOutputAttributeAggregator.processAdd(data);
    }

    @Override
    public Object processAdd(Object[] data) {
        return new IllegalStateException("Stddev cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object processRemove(Object data) {
        return this.stddevOutputAttributeAggregator.processRemove(data);
    }

    @Override
    public Object processRemove(Object[] data) {
        return new IllegalStateException("Stddev cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object reset() {
        return this.stddevOutputAttributeAggregator.reset();
    }

    @Override
    public Object[] currentState() {
        return this.stddevOutputAttributeAggregator.currentState();
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void restoreState(Object[] state) {
        this.stddevOutputAttributeAggregator.restoreState(state);
    }

    private class StddevAttributeAggregatorLong
    extends StddevAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.DOUBLE;
        private double mean;
        private double oldMean;
        private double stdDeviation;
        private double sum;
        private int count = 0;

        private StddevAttributeAggregatorLong() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public Object processAdd(Object data) {
            ++this.count;
            double value = ((Long)data).longValue();
            if (this.count == 1) {
                this.mean = this.oldMean = value;
                this.sum = this.oldMean;
                this.stdDeviation = 0.0;
            } else {
                this.oldMean = this.mean;
                this.sum += value;
                this.mean = this.sum / (double)this.count;
                this.stdDeviation += (value - this.oldMean) * (value - this.mean);
            }
            if (this.count < 2) {
                return 0.0;
            }
            return Math.sqrt(this.stdDeviation / (double)this.count);
        }

        @Override
        public Object processRemove(Object data) {
            --this.count;
            double value = ((Long)data).longValue();
            if (this.count == 0) {
                this.mean = 0.0;
                this.sum = 0.0;
                this.stdDeviation = 0.0;
            } else {
                this.oldMean = this.mean;
                this.sum -= value;
                this.mean = this.sum / (double)this.count;
                this.stdDeviation -= (value - this.oldMean) * (value - this.mean);
            }
            if (this.count < 2) {
                return 0.0;
            }
            return Math.sqrt(this.stdDeviation / (double)this.count);
        }

        @Override
        public Object reset() {
            this.oldMean = 0.0;
            this.mean = 0.0;
            this.sum = 0.0;
            this.stdDeviation = 0.0;
            this.count = 0;
            return 0.0;
        }

        @Override
        public Object[] currentState() {
            return new Object[]{new AbstractMap.SimpleEntry<String, Double>("Sum", this.sum), new AbstractMap.SimpleEntry<String, Double>("Mean", this.mean), new AbstractMap.SimpleEntry<String, Double>("OldMean", this.oldMean), new AbstractMap.SimpleEntry<String, Double>("StandardDeviation", this.stdDeviation), new AbstractMap.SimpleEntry<String, Integer>("Count", this.count)};
        }

        @Override
        public void restoreState(Object[] state) {
            Map.Entry stateEntry = (Map.Entry)state[0];
            this.sum = (Double)stateEntry.getValue();
            Map.Entry stateEntry2 = (Map.Entry)state[1];
            this.mean = (Double)stateEntry2.getValue();
            Map.Entry stateEntry3 = (Map.Entry)state[2];
            this.oldMean = (Double)stateEntry3.getValue();
            Map.Entry stateEntry4 = (Map.Entry)state[3];
            this.stdDeviation = (Double)stateEntry4.getValue();
            Map.Entry stateEntry5 = (Map.Entry)state[4];
            this.count = (Integer)stateEntry5.getValue();
        }
    }

    private class StddevAttributeAggregatorInt
    extends StddevAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.DOUBLE;
        private double mean;
        private double oldMean;
        private double stdDeviation;
        private double sum;
        private int count = 0;

        private StddevAttributeAggregatorInt() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public Object processAdd(Object data) {
            ++this.count;
            double value = ((Integer)data).intValue();
            if (this.count == 1) {
                this.mean = this.oldMean = value;
                this.sum = this.oldMean;
                this.stdDeviation = 0.0;
            } else {
                this.oldMean = this.mean;
                this.sum += value;
                this.mean = this.sum / (double)this.count;
                this.stdDeviation += (value - this.oldMean) * (value - this.mean);
            }
            if (this.count < 2) {
                return 0.0;
            }
            return Math.sqrt(this.stdDeviation / (double)this.count);
        }

        @Override
        public Object processRemove(Object data) {
            --this.count;
            double value = ((Integer)data).intValue();
            if (this.count == 0) {
                this.mean = 0.0;
                this.sum = 0.0;
                this.stdDeviation = 0.0;
            } else {
                this.oldMean = this.mean;
                this.sum -= value;
                this.mean = this.sum / (double)this.count;
                this.stdDeviation -= (value - this.oldMean) * (value - this.mean);
            }
            if (this.count < 2) {
                return 0.0;
            }
            return Math.sqrt(this.stdDeviation / (double)this.count);
        }

        @Override
        public Object reset() {
            this.oldMean = 0.0;
            this.mean = 0.0;
            this.sum = 0.0;
            this.stdDeviation = 0.0;
            this.count = 0;
            return 0.0;
        }

        @Override
        public Object[] currentState() {
            return new Object[]{new AbstractMap.SimpleEntry<String, Double>("Sum", this.sum), new AbstractMap.SimpleEntry<String, Double>("Mean", this.mean), new AbstractMap.SimpleEntry<String, Double>("OldMean", this.oldMean), new AbstractMap.SimpleEntry<String, Double>("StandardDeviation", this.stdDeviation), new AbstractMap.SimpleEntry<String, Integer>("Count", this.count)};
        }

        @Override
        public void restoreState(Object[] state) {
            Map.Entry stateEntry = (Map.Entry)state[0];
            this.sum = (Double)stateEntry.getValue();
            Map.Entry stateEntry2 = (Map.Entry)state[1];
            this.mean = (Double)stateEntry2.getValue();
            Map.Entry stateEntry3 = (Map.Entry)state[2];
            this.oldMean = (Double)stateEntry3.getValue();
            Map.Entry stateEntry4 = (Map.Entry)state[3];
            this.stdDeviation = (Double)stateEntry4.getValue();
            Map.Entry stateEntry5 = (Map.Entry)state[4];
            this.count = (Integer)stateEntry5.getValue();
        }
    }

    private class StddevAttributeAggregatorFloat
    extends StddevAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.DOUBLE;
        private double mean;
        private double oldMean;
        private double stdDeviation;
        private double sum;
        private int count = 0;

        private StddevAttributeAggregatorFloat() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public Object processAdd(Object data) {
            ++this.count;
            double value = ((Float)data).floatValue();
            if (this.count == 1) {
                this.mean = this.oldMean = value;
                this.sum = this.oldMean;
                this.stdDeviation = 0.0;
            } else {
                this.oldMean = this.mean;
                this.sum += value;
                this.mean = this.sum / (double)this.count;
                this.stdDeviation += (value - this.oldMean) * (value - this.mean);
            }
            if (this.count < 2) {
                return 0.0;
            }
            return Math.sqrt(this.stdDeviation / (double)this.count);
        }

        @Override
        public Object processRemove(Object data) {
            --this.count;
            double value = ((Float)data).floatValue();
            if (this.count == 0) {
                this.mean = 0.0;
                this.sum = 0.0;
                this.stdDeviation = 0.0;
            } else {
                this.oldMean = this.mean;
                this.sum -= value;
                this.mean = this.sum / (double)this.count;
                this.stdDeviation -= (value - this.oldMean) * (value - this.mean);
            }
            if (this.count < 2) {
                return 0.0;
            }
            return Math.sqrt(this.stdDeviation / (double)this.count);
        }

        @Override
        public Object reset() {
            this.oldMean = 0.0;
            this.mean = 0.0;
            this.sum = 0.0;
            this.stdDeviation = 0.0;
            this.count = 0;
            return 0.0;
        }

        @Override
        public Object[] currentState() {
            return new Object[]{new AbstractMap.SimpleEntry<String, Double>("Sum", this.sum), new AbstractMap.SimpleEntry<String, Double>("Mean", this.mean), new AbstractMap.SimpleEntry<String, Double>("OldMean", this.oldMean), new AbstractMap.SimpleEntry<String, Double>("StandardDeviation", this.stdDeviation), new AbstractMap.SimpleEntry<String, Integer>("Count", this.count)};
        }

        @Override
        public void restoreState(Object[] state) {
            Map.Entry stateEntry = (Map.Entry)state[0];
            this.sum = (Double)stateEntry.getValue();
            Map.Entry stateEntry2 = (Map.Entry)state[1];
            this.mean = (Double)stateEntry2.getValue();
            Map.Entry stateEntry3 = (Map.Entry)state[2];
            this.oldMean = (Double)stateEntry3.getValue();
            Map.Entry stateEntry4 = (Map.Entry)state[3];
            this.stdDeviation = (Double)stateEntry4.getValue();
            Map.Entry stateEntry5 = (Map.Entry)state[4];
            this.count = (Integer)stateEntry5.getValue();
        }
    }

    private class StddevAttributeAggregatorDouble
    extends StddevAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.DOUBLE;
        private double mean;
        private double oldMean;
        private double stdDeviation;
        private double sum;
        private int count = 0;

        private StddevAttributeAggregatorDouble() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public Object processAdd(Object data) {
            ++this.count;
            double value = (Double)data;
            if (this.count == 1) {
                this.mean = this.oldMean = value;
                this.sum = this.oldMean;
                this.stdDeviation = 0.0;
            } else {
                this.oldMean = this.mean;
                this.sum += value;
                this.mean = this.sum / (double)this.count;
                this.stdDeviation += (value - this.oldMean) * (value - this.mean);
            }
            if (this.count < 2) {
                return 0.0;
            }
            return Math.sqrt(this.stdDeviation / (double)this.count);
        }

        @Override
        public Object processRemove(Object data) {
            --this.count;
            double value = (Double)data;
            if (this.count == 0) {
                this.mean = 0.0;
                this.sum = 0.0;
                this.stdDeviation = 0.0;
            } else {
                this.oldMean = this.mean;
                this.sum -= value;
                this.mean = this.sum / (double)this.count;
                this.stdDeviation -= (value - this.oldMean) * (value - this.mean);
            }
            if (this.count < 2) {
                return 0.0;
            }
            return Math.sqrt(this.stdDeviation / (double)this.count);
        }

        @Override
        public Object reset() {
            this.oldMean = 0.0;
            this.mean = 0.0;
            this.sum = 0.0;
            this.stdDeviation = 0.0;
            this.count = 0;
            return 0.0;
        }

        @Override
        public Object[] currentState() {
            return new Object[]{this.sum, this.mean, this.oldMean, this.stdDeviation, this.count};
        }

        @Override
        public void restoreState(Object[] state) {
            this.sum = (Double)state[0];
            this.mean = (Double)state[1];
            this.oldMean = (Double)state[2];
            this.stdDeviation = (Double)state[3];
            this.count = (Integer)state[4];
        }
    }
}

