/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.selector.attribute.aggregator;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.exception.OperationNotSupportedException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.query.selector.attribute.aggregator.AttributeAggregator;
import org.wso2.siddhi.query.api.definition.Attribute;

public class MinForeverAttributeAggregator
extends AttributeAggregator {
    private MinForeverAttributeAggregator minForeverAttributeAggregator;

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new OperationNotSupportedException("MinForever aggregator has to have exactly 1 parameter, currently " + attributeExpressionExecutors.length + " parameters provided");
        }
        Attribute.Type type = attributeExpressionExecutors[0].getReturnType();
        switch (type) {
            case FLOAT: {
                this.minForeverAttributeAggregator = new MinForeverAttributeAggregatorFloat();
                break;
            }
            case INT: {
                this.minForeverAttributeAggregator = new MinForeverAttributeAggregatorInt();
                break;
            }
            case LONG: {
                this.minForeverAttributeAggregator = new MinForeverAttributeAggregatorLong();
                break;
            }
            case DOUBLE: {
                this.minForeverAttributeAggregator = new MinForeverAttributeAggregatorDouble();
                break;
            }
            default: {
                throw new OperationNotSupportedException("MinForever not supported for " + type);
            }
        }
    }

    @Override
    public Attribute.Type getReturnType() {
        return this.minForeverAttributeAggregator.getReturnType();
    }

    @Override
    public Object processAdd(Object data) {
        return this.minForeverAttributeAggregator.processAdd(data);
    }

    @Override
    public Object processAdd(Object[] data) {
        return new IllegalStateException("MinForever cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object processRemove(Object data) {
        return this.minForeverAttributeAggregator.processRemove(data);
    }

    @Override
    public Object processRemove(Object[] data) {
        return new IllegalStateException("MinForever cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object reset() {
        return this.minForeverAttributeAggregator.reset();
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Object[] currentState() {
        return this.minForeverAttributeAggregator.currentState();
    }

    @Override
    public void restoreState(Object[] state) {
        this.minForeverAttributeAggregator.restoreState(state);
    }

    class MinForeverAttributeAggregatorLong
    extends MinForeverAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.LONG;
        private volatile Long minValue = null;

        MinForeverAttributeAggregatorLong() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public synchronized Object processAdd(Object data) {
            Long value = (Long)data;
            if (this.minValue == null || this.minValue > value) {
                this.minValue = value;
            }
            return this.minValue;
        }

        @Override
        public Object reset() {
            return this.minValue;
        }

        @Override
        public synchronized Object processRemove(Object data) {
            Long value = (Long)data;
            if (this.minValue == null || this.minValue > value) {
                this.minValue = value;
            }
            return this.minValue;
        }

        @Override
        public Object[] currentState() {
            return new Object[]{new AbstractMap.SimpleEntry<String, Long>("MinValue", this.minValue)};
        }

        @Override
        public void restoreState(Object[] state) {
            Map.Entry stateEntry = (Map.Entry)state[0];
            this.minValue = (Long)stateEntry.getValue();
        }
    }

    class MinForeverAttributeAggregatorInt
    extends MinForeverAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.INT;
        private volatile Integer minValue = null;

        MinForeverAttributeAggregatorInt() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public synchronized Object processAdd(Object data) {
            Integer value = (Integer)data;
            if (this.minValue == null || this.minValue > value) {
                this.minValue = value;
            }
            return this.minValue;
        }

        @Override
        public Object reset() {
            return this.minValue;
        }

        @Override
        public synchronized Object processRemove(Object data) {
            Integer value = (Integer)data;
            if (this.minValue == null || this.minValue > value) {
                this.minValue = value;
            }
            return this.minValue;
        }

        @Override
        public Object[] currentState() {
            return new Object[]{new AbstractMap.SimpleEntry<String, Integer>("MinValue", this.minValue)};
        }

        @Override
        public void restoreState(Object[] state) {
            Map.Entry stateEntry = (Map.Entry)state[0];
            this.minValue = (Integer)stateEntry.getValue();
        }
    }

    class MinForeverAttributeAggregatorFloat
    extends MinForeverAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.FLOAT;
        private volatile Float minValue = null;

        MinForeverAttributeAggregatorFloat() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public synchronized Object processAdd(Object data) {
            Float value = (Float)data;
            if (this.minValue == null || this.minValue.floatValue() > value.floatValue()) {
                this.minValue = value;
            }
            return this.minValue;
        }

        @Override
        public synchronized Object processRemove(Object data) {
            Float value = (Float)data;
            if (this.minValue == null || this.minValue.floatValue() > value.floatValue()) {
                this.minValue = value;
            }
            return this.minValue;
        }

        @Override
        public Object reset() {
            return this.minValue;
        }

        @Override
        public Object[] currentState() {
            return new Object[]{new AbstractMap.SimpleEntry<String, Float>("MinValue", this.minValue)};
        }

        @Override
        public void restoreState(Object[] state) {
            Map.Entry stateEntry = (Map.Entry)state[0];
            this.minValue = (Float)stateEntry.getValue();
        }
    }

    class MinForeverAttributeAggregatorDouble
    extends MinForeverAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.DOUBLE;
        private volatile Double minValue = null;

        MinForeverAttributeAggregatorDouble() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public synchronized Object processAdd(Object data) {
            Double value = (Double)data;
            if (this.minValue == null || this.minValue > value) {
                this.minValue = value;
            }
            return this.minValue;
        }

        @Override
        public synchronized Object processRemove(Object data) {
            Double value = (Double)data;
            if (this.minValue == null || this.minValue > value) {
                this.minValue = value;
            }
            return this.minValue;
        }

        @Override
        public Object reset() {
            return this.minValue;
        }

        @Override
        public Object[] currentState() {
            return new Object[]{new AbstractMap.SimpleEntry<String, Double>("MinValue", this.minValue)};
        }

        @Override
        public void restoreState(Object[] state) {
            Map.Entry stateEntry = (Map.Entry)state[0];
            this.minValue = (Double)stateEntry.getValue();
        }
    }
}

