/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.selector.attribute.aggregator;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.exception.OperationNotSupportedException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.query.selector.attribute.aggregator.AttributeAggregator;
import org.wso2.siddhi.query.api.definition.Attribute;

public class MinAttributeAggregator
extends AttributeAggregator {
    private MinAttributeAggregator minOutputAttributeAggregator;

    public void init(Attribute.Type type) {
    }

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new OperationNotSupportedException("Min aggregator has to have exactly 1 parameter, currently " + attributeExpressionExecutors.length + " parameters provided");
        }
        Attribute.Type type = attributeExpressionExecutors[0].getReturnType();
        switch (type) {
            case FLOAT: {
                this.minOutputAttributeAggregator = new MinAttributeAggregatorFloat();
                break;
            }
            case INT: {
                this.minOutputAttributeAggregator = new MinAttributeAggregatorInt();
                break;
            }
            case LONG: {
                this.minOutputAttributeAggregator = new MinAttributeAggregatorLong();
                break;
            }
            case DOUBLE: {
                this.minOutputAttributeAggregator = new MinAttributeAggregatorDouble();
                break;
            }
            default: {
                throw new OperationNotSupportedException("Min not supported for " + type);
            }
        }
    }

    @Override
    public Attribute.Type getReturnType() {
        return this.minOutputAttributeAggregator.getReturnType();
    }

    @Override
    public Object processAdd(Object data) {
        return this.minOutputAttributeAggregator.processAdd(data);
    }

    @Override
    public Object processAdd(Object[] data) {
        return new IllegalStateException("Min cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object processRemove(Object data) {
        return this.minOutputAttributeAggregator.processRemove(data);
    }

    @Override
    public Object processRemove(Object[] data) {
        return new IllegalStateException("Min cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object reset() {
        return this.minOutputAttributeAggregator.reset();
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Object[] currentState() {
        return this.minOutputAttributeAggregator.currentState();
    }

    @Override
    public void restoreState(Object[] state) {
        this.minOutputAttributeAggregator.restoreState(state);
    }

    class MinAttributeAggregatorLong
    extends MinAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.LONG;
        private Deque<Long> minDeque = new LinkedList<Long>();
        private volatile Long minValue = null;

        MinAttributeAggregatorLong() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public synchronized Object processAdd(Object data) {
            Long value = (Long)data;
            Iterator<Long> iterator = this.minDeque.descendingIterator();
            while (iterator.hasNext() && iterator.next() > value) {
                iterator.remove();
            }
            this.minDeque.addLast(value);
            if (this.minValue == null || this.minValue > value) {
                this.minValue = value;
            }
            return this.minValue;
        }

        @Override
        public Object reset() {
            this.minDeque.clear();
            this.minValue = null;
            return null;
        }

        @Override
        public synchronized Object processRemove(Object data) {
            this.minDeque.removeFirstOccurrence(data);
            this.minValue = this.minDeque.peekFirst();
            return this.minValue;
        }

        @Override
        public Object[] currentState() {
            return new Object[]{new AbstractMap.SimpleEntry<String, Deque<Long>>("MinDeque", this.minDeque), new AbstractMap.SimpleEntry<String, Long>("MinValue", this.minValue)};
        }

        @Override
        public void restoreState(Object[] state) {
            Map.Entry stateEntry = (Map.Entry)state[0];
            this.minDeque = (Deque)stateEntry.getValue();
            Map.Entry stateEntry2 = (Map.Entry)state[1];
            this.minValue = (Long)stateEntry2.getValue();
        }
    }

    class MinAttributeAggregatorInt
    extends MinAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.INT;
        private Deque<Integer> minDeque = new LinkedList<Integer>();
        private volatile Integer minValue = null;

        MinAttributeAggregatorInt() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public synchronized Object processAdd(Object data) {
            Integer value = (Integer)data;
            Iterator<Integer> iterator = this.minDeque.descendingIterator();
            while (iterator.hasNext() && iterator.next() > value) {
                iterator.remove();
            }
            this.minDeque.addLast(value);
            if (this.minValue == null || this.minValue > value) {
                this.minValue = value;
            }
            return this.minValue;
        }

        @Override
        public Object reset() {
            this.minDeque.clear();
            this.minValue = null;
            return null;
        }

        @Override
        public synchronized Object processRemove(Object data) {
            this.minDeque.removeFirstOccurrence(data);
            this.minValue = this.minDeque.peekFirst();
            return this.minValue;
        }

        @Override
        public Object[] currentState() {
            return new Object[]{new AbstractMap.SimpleEntry<String, Deque<Integer>>("MinDeque", this.minDeque), new AbstractMap.SimpleEntry<String, Integer>("MinValue", this.minValue)};
        }

        @Override
        public void restoreState(Object[] state) {
            Map.Entry stateEntry = (Map.Entry)state[0];
            this.minDeque = (Deque)stateEntry.getValue();
            Map.Entry stateEntry2 = (Map.Entry)state[1];
            this.minValue = (Integer)stateEntry2.getValue();
        }
    }

    class MinAttributeAggregatorFloat
    extends MinAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.FLOAT;
        private Deque<Float> minDeque = new LinkedList<Float>();
        private volatile Float minValue = null;

        MinAttributeAggregatorFloat() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public synchronized Object processAdd(Object data) {
            Float value = (Float)data;
            Iterator<Float> iterator = this.minDeque.descendingIterator();
            while (iterator.hasNext() && iterator.next().floatValue() > value.floatValue()) {
                iterator.remove();
            }
            this.minDeque.addLast(value);
            if (this.minValue == null || this.minValue.floatValue() > value.floatValue()) {
                this.minValue = value;
            }
            return this.minValue;
        }

        @Override
        public synchronized Object processRemove(Object data) {
            this.minDeque.removeFirstOccurrence(data);
            this.minValue = this.minDeque.peekFirst();
            return this.minValue;
        }

        @Override
        public Object reset() {
            this.minDeque.clear();
            this.minValue = null;
            return null;
        }

        @Override
        public Object[] currentState() {
            return new Object[]{new AbstractMap.SimpleEntry<String, Deque<Float>>("MinDeque", this.minDeque), new AbstractMap.SimpleEntry<String, Float>("MinValue", this.minValue)};
        }

        @Override
        public void restoreState(Object[] state) {
            Map.Entry stateEntry = (Map.Entry)state[0];
            this.minDeque = (Deque)stateEntry.getValue();
            Map.Entry stateEntry2 = (Map.Entry)state[1];
            this.minValue = (Float)stateEntry2.getValue();
        }
    }

    class MinAttributeAggregatorDouble
    extends MinAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.DOUBLE;
        private Deque<Double> minDeque = new LinkedList<Double>();
        private volatile Double minValue = null;

        MinAttributeAggregatorDouble() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public synchronized Object processAdd(Object data) {
            Double value = (Double)data;
            Iterator<Double> iterator = this.minDeque.descendingIterator();
            while (iterator.hasNext() && iterator.next() > value) {
                iterator.remove();
            }
            this.minDeque.addLast(value);
            if (this.minValue == null || this.minValue > value) {
                this.minValue = value;
            }
            return this.minValue;
        }

        @Override
        public synchronized Object processRemove(Object data) {
            this.minDeque.removeFirstOccurrence(data);
            this.minValue = this.minDeque.peekFirst();
            return this.minValue;
        }

        @Override
        public Object reset() {
            this.minDeque.clear();
            this.minValue = null;
            return null;
        }

        @Override
        public Object[] currentState() {
            return new Object[]{new AbstractMap.SimpleEntry<String, Deque<Double>>("MinDeque", this.minDeque), new AbstractMap.SimpleEntry<String, Double>("MinValue", this.minValue)};
        }

        @Override
        public void restoreState(Object[] state) {
            Map.Entry stateEntry = (Map.Entry)state[0];
            this.minDeque = (Deque)stateEntry.getValue();
            Map.Entry stateEntry2 = (Map.Entry)state[1];
            this.minValue = (Double)stateEntry2.getValue();
        }
    }
}

