/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.processor.stream.window;

import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.executor.ConstantExpressionExecutor;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.processor.SchedulingProcessor;
import org.wso2.siddhi.core.query.processor.stream.window.FindableProcessor;
import org.wso2.siddhi.core.query.processor.stream.window.WindowProcessor;
import org.wso2.siddhi.core.table.EventTable;
import org.wso2.siddhi.core.util.Scheduler;
import org.wso2.siddhi.core.util.collection.operator.Finder;
import org.wso2.siddhi.core.util.collection.operator.MatchingMetaStateHolder;
import org.wso2.siddhi.core.util.parser.OperatorParser;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;
import org.wso2.siddhi.query.api.expression.Expression;

public class TimeBatchWindowProcessor
extends WindowProcessor
implements SchedulingProcessor,
FindableProcessor {
    private long timeInMilliSeconds;
    private long nextEmitTime = -1L;
    private ComplexEventChunk<StreamEvent> currentEventChunk = new ComplexEventChunk(false);
    private ComplexEventChunk<StreamEvent> expiredEventChunk = null;
    private StreamEvent resetEvent = null;
    private Scheduler scheduler;
    private ExecutionPlanContext executionPlanContext;
    private boolean isStartTimeEnabled = false;
    private long startTime = 0L;

    @Override
    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        this.executionPlanContext = executionPlanContext;
        if (this.outputExpectsExpiredEvents) {
            this.expiredEventChunk = new ComplexEventChunk(false);
        }
        if (attributeExpressionExecutors.length == 1) {
            if (!(attributeExpressionExecutors[0] instanceof ConstantExpressionExecutor)) throw new ExecutionPlanValidationException("Time window should have constant parameter attribute but found a dynamic attribute " + attributeExpressionExecutors[0].getClass().getCanonicalName());
            if (attributeExpressionExecutors[0].getReturnType() == Attribute.Type.INT) {
                this.timeInMilliSeconds = ((Integer)((ConstantExpressionExecutor)attributeExpressionExecutors[0]).getValue()).intValue();
                return;
            } else {
                if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.LONG) throw new ExecutionPlanValidationException("Time window's parameter attribute should be either int or long, but found " + attributeExpressionExecutors[0].getReturnType());
                this.timeInMilliSeconds = (Long)((ConstantExpressionExecutor)attributeExpressionExecutors[0]).getValue();
            }
            return;
        } else {
            if (attributeExpressionExecutors.length != 2) throw new ExecutionPlanValidationException("Time window should only have one or two parameters. (<int|long|time> windowTime), but found " + attributeExpressionExecutors.length + " input attributes");
            if (!(attributeExpressionExecutors[0] instanceof ConstantExpressionExecutor)) throw new ExecutionPlanValidationException("Time window should have constant parameter attribute but found a dynamic attribute " + attributeExpressionExecutors[0].getClass().getCanonicalName());
            if (attributeExpressionExecutors[0].getReturnType() == Attribute.Type.INT) {
                this.timeInMilliSeconds = ((Integer)((ConstantExpressionExecutor)attributeExpressionExecutors[0]).getValue()).intValue();
            } else {
                if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.LONG) throw new ExecutionPlanValidationException("Time window's parameter attribute should be either int or long, but found " + attributeExpressionExecutors[0].getReturnType());
                this.timeInMilliSeconds = (Long)((ConstantExpressionExecutor)attributeExpressionExecutors[0]).getValue();
            }
            this.isStartTimeEnabled = true;
            this.startTime = attributeExpressionExecutors[1].getReturnType() == Attribute.Type.INT ? (long)Integer.parseInt(String.valueOf(((ConstantExpressionExecutor)attributeExpressionExecutors[1]).getValue())) : Long.parseLong(String.valueOf(((ConstantExpressionExecutor)attributeExpressionExecutors[1]).getValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner) {
        TimeBatchWindowProcessor timeBatchWindowProcessor = this;
        synchronized (timeBatchWindowProcessor) {
            boolean sendEvents;
            long currentTime;
            if (this.nextEmitTime == -1L) {
                currentTime = this.executionPlanContext.getTimestampGenerator().currentTime();
                this.nextEmitTime = this.isStartTimeEnabled ? this.getNextEmitTime(currentTime) : this.executionPlanContext.getTimestampGenerator().currentTime() + this.timeInMilliSeconds;
                this.scheduler.notifyAt(this.nextEmitTime);
            }
            if ((currentTime = this.executionPlanContext.getTimestampGenerator().currentTime()) >= this.nextEmitTime) {
                this.nextEmitTime += this.timeInMilliSeconds;
                this.scheduler.notifyAt(this.nextEmitTime);
                sendEvents = true;
            } else {
                sendEvents = false;
            }
            while (streamEventChunk.hasNext()) {
                StreamEvent streamEvent = (StreamEvent)streamEventChunk.next();
                if (streamEvent.getType() != ComplexEvent.Type.CURRENT) continue;
                StreamEvent clonedStreamEvent = streamEventCloner.copyStreamEvent(streamEvent);
                this.currentEventChunk.add(clonedStreamEvent);
            }
            streamEventChunk.clear();
            if (sendEvents) {
                if (this.outputExpectsExpiredEvents && this.expiredEventChunk.getFirst() != null) {
                    while (this.expiredEventChunk.hasNext()) {
                        StreamEvent expiredEvent = (StreamEvent)this.expiredEventChunk.next();
                        expiredEvent.setTimestamp(currentTime);
                    }
                    streamEventChunk.add(this.expiredEventChunk.getFirst());
                }
                if (this.expiredEventChunk != null) {
                    this.expiredEventChunk.clear();
                }
                if (this.currentEventChunk.getFirst() != null) {
                    streamEventChunk.add(this.resetEvent);
                    this.resetEvent = null;
                    if (this.expiredEventChunk != null) {
                        this.currentEventChunk.reset();
                        while (this.currentEventChunk.hasNext()) {
                            StreamEvent currentEvent = (StreamEvent)this.currentEventChunk.next();
                            StreamEvent toExpireEvent = streamEventCloner.copyStreamEvent(currentEvent);
                            toExpireEvent.setType(ComplexEvent.Type.EXPIRED);
                            this.expiredEventChunk.add(toExpireEvent);
                        }
                    }
                    this.resetEvent = streamEventCloner.copyStreamEvent(this.currentEventChunk.getFirst());
                    this.resetEvent.setType(ComplexEvent.Type.RESET);
                    streamEventChunk.add(this.currentEventChunk.getFirst());
                }
                this.currentEventChunk.clear();
            }
        }
        if (streamEventChunk.getFirst() != null) {
            streamEventChunk.setBatch(true);
            nextProcessor.process(streamEventChunk);
            streamEventChunk.setBatch(false);
        }
    }

    private long getNextEmitTime(long currentTime) {
        long elapsedTimeSinceLastEmit = (currentTime - this.startTime) % this.timeInMilliSeconds;
        long emitTime = currentTime + (this.timeInMilliSeconds - elapsedTimeSinceLastEmit);
        return emitTime;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Object[] currentState() {
        if (this.expiredEventChunk != null) {
            return new Object[]{new AbstractMap.SimpleEntry<String, StreamEvent>("CurrentEventChunk", this.currentEventChunk.getFirst()), new AbstractMap.SimpleEntry<String, StreamEvent>("ExpiredEventChunk", this.expiredEventChunk.getFirst()), new AbstractMap.SimpleEntry<String, StreamEvent>("ResetEvent", this.resetEvent)};
        }
        return new Object[]{new AbstractMap.SimpleEntry<String, StreamEvent>("CurrentEventChunk", this.currentEventChunk.getFirst()), new AbstractMap.SimpleEntry<String, StreamEvent>("ResetEvent", this.resetEvent)};
    }

    @Override
    public void restoreState(Object[] state) {
        if (state.length > 2) {
            this.currentEventChunk.clear();
            Map.Entry stateEntry = (Map.Entry)state[0];
            this.currentEventChunk.add((StreamEvent)stateEntry.getValue());
            this.expiredEventChunk.clear();
            Map.Entry stateEntry2 = (Map.Entry)state[1];
            this.expiredEventChunk.add((StreamEvent)stateEntry2.getValue());
            Map.Entry stateEntry3 = (Map.Entry)state[2];
            this.resetEvent = (StreamEvent)stateEntry3.getValue();
        } else {
            this.currentEventChunk.clear();
            Map.Entry stateEntry = (Map.Entry)state[0];
            this.currentEventChunk.add((StreamEvent)stateEntry.getValue());
            Map.Entry stateEntry2 = (Map.Entry)state[1];
            this.resetEvent = (StreamEvent)stateEntry2.getValue();
        }
    }

    @Override
    public synchronized StreamEvent find(StateEvent matchingEvent, Finder finder) {
        return finder.find(matchingEvent, this.expiredEventChunk, this.streamEventCloner);
    }

    @Override
    public Finder constructFinder(Expression expression, MatchingMetaStateHolder matchingMetaStateHolder, ExecutionPlanContext executionPlanContext, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, EventTable> eventTableMap) {
        if (this.expiredEventChunk == null) {
            this.expiredEventChunk = new ComplexEventChunk(false);
        }
        return OperatorParser.constructOperator(this.expiredEventChunk, expression, matchingMetaStateHolder, executionPlanContext, variableExpressionExecutors, eventTableMap, this.queryName);
    }
}

