/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.processor.stream.window;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.executor.ConstantExpressionExecutor;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.processor.stream.window.FindableProcessor;
import org.wso2.siddhi.core.query.processor.stream.window.WindowProcessor;
import org.wso2.siddhi.core.table.EventTable;
import org.wso2.siddhi.core.util.collection.operator.Finder;
import org.wso2.siddhi.core.util.collection.operator.MatchingMetaStateHolder;
import org.wso2.siddhi.core.util.parser.OperatorParser;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;
import org.wso2.siddhi.query.api.expression.Expression;

public class LengthBatchWindowProcessor
extends WindowProcessor
implements FindableProcessor {
    private int length;
    private int count = 0;
    private ComplexEventChunk<StreamEvent> currentEventChunk = new ComplexEventChunk(false);
    private ComplexEventChunk<StreamEvent> expiredEventChunk = null;
    private ExecutionPlanContext executionPlanContext;
    private StreamEvent resetEvent = null;

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        this.executionPlanContext = executionPlanContext;
        if (this.outputExpectsExpiredEvents) {
            this.expiredEventChunk = new ComplexEventChunk(false);
        }
        if (attributeExpressionExecutors.length != 1) {
            throw new ExecutionPlanValidationException("Length batch window should only have one parameter (<int> windowLength), but found " + attributeExpressionExecutors.length + " input attributes");
        }
        this.length = (Integer)((ConstantExpressionExecutor)attributeExpressionExecutors[0]).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner) {
        ArrayList<ComplexEventChunk> streamEventChunks = new ArrayList<ComplexEventChunk>();
        LengthBatchWindowProcessor lengthBatchWindowProcessor = this;
        synchronized (lengthBatchWindowProcessor) {
            ComplexEventChunk outputStreamEventChunk = new ComplexEventChunk(true);
            long currentTime = this.executionPlanContext.getTimestampGenerator().currentTime();
            while (streamEventChunk.hasNext()) {
                StreamEvent streamEvent = (StreamEvent)streamEventChunk.next();
                StreamEvent clonedStreamEvent = streamEventCloner.copyStreamEvent(streamEvent);
                this.currentEventChunk.add(clonedStreamEvent);
                ++this.count;
                if (this.count != this.length) continue;
                if (this.outputExpectsExpiredEvents && this.expiredEventChunk.getFirst() != null) {
                    while (this.expiredEventChunk.hasNext()) {
                        StreamEvent expiredEvent = (StreamEvent)this.expiredEventChunk.next();
                        expiredEvent.setTimestamp(currentTime);
                    }
                    outputStreamEventChunk.add(this.expiredEventChunk.getFirst());
                }
                if (this.expiredEventChunk != null) {
                    this.expiredEventChunk.clear();
                }
                if (this.currentEventChunk.getFirst() != null) {
                    outputStreamEventChunk.add(this.resetEvent);
                    this.resetEvent = null;
                    if (this.expiredEventChunk != null) {
                        this.currentEventChunk.reset();
                        while (this.currentEventChunk.hasNext()) {
                            StreamEvent currentEvent = (StreamEvent)this.currentEventChunk.next();
                            StreamEvent toExpireEvent = streamEventCloner.copyStreamEvent(currentEvent);
                            toExpireEvent.setType(ComplexEvent.Type.EXPIRED);
                            this.expiredEventChunk.add(toExpireEvent);
                        }
                    }
                    this.resetEvent = streamEventCloner.copyStreamEvent(this.currentEventChunk.getFirst());
                    this.resetEvent.setType(ComplexEvent.Type.RESET);
                    outputStreamEventChunk.add(this.currentEventChunk.getFirst());
                }
                this.currentEventChunk.clear();
                this.count = 0;
                if (outputStreamEventChunk.getFirst() == null) continue;
                streamEventChunks.add(outputStreamEventChunk);
            }
        }
        for (ComplexEventChunk outputStreamEventChunk : streamEventChunks) {
            nextProcessor.process(outputStreamEventChunk);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Object[] currentState() {
        if (this.expiredEventChunk != null) {
            return new Object[]{new AbstractMap.SimpleEntry<String, StreamEvent>("CurrentEventChunk", this.currentEventChunk.getFirst()), new AbstractMap.SimpleEntry<String, StreamEvent>("ExpiredEventChunk", this.expiredEventChunk.getFirst()), new AbstractMap.SimpleEntry<String, Integer>("Count", this.count), new AbstractMap.SimpleEntry<String, StreamEvent>("ResetEvent", this.resetEvent)};
        }
        return new Object[]{new AbstractMap.SimpleEntry<String, StreamEvent>("CurrentEventChunk", this.currentEventChunk.getFirst()), new AbstractMap.SimpleEntry<String, Integer>("Count", this.count), new AbstractMap.SimpleEntry<String, StreamEvent>("ResetEvent", this.resetEvent)};
    }

    @Override
    public void restoreState(Object[] state) {
        if (state.length > 3) {
            this.currentEventChunk.clear();
            Map.Entry stateEntry = (Map.Entry)state[0];
            this.currentEventChunk.add((StreamEvent)stateEntry.getValue());
            this.expiredEventChunk.clear();
            Map.Entry stateEntry2 = (Map.Entry)state[1];
            this.expiredEventChunk.add((StreamEvent)stateEntry2.getValue());
            Map.Entry stateEntry3 = (Map.Entry)state[2];
            this.count = (Integer)stateEntry3.getValue();
            Map.Entry stateEntry4 = (Map.Entry)state[3];
            this.resetEvent = (StreamEvent)stateEntry4.getValue();
        } else {
            this.currentEventChunk.clear();
            Map.Entry stateEntry = (Map.Entry)state[0];
            this.currentEventChunk.add((StreamEvent)stateEntry.getValue());
            Map.Entry stateEntry2 = (Map.Entry)state[1];
            this.count = (Integer)stateEntry2.getValue();
            Map.Entry stateEntry3 = (Map.Entry)state[2];
            this.resetEvent = (StreamEvent)stateEntry3.getValue();
        }
    }

    @Override
    public synchronized StreamEvent find(StateEvent matchingEvent, Finder finder) {
        return finder.find(matchingEvent, this.expiredEventChunk, this.streamEventCloner);
    }

    @Override
    public Finder constructFinder(Expression expression, MatchingMetaStateHolder matchingMetaStateHolder, ExecutionPlanContext executionPlanContext, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, EventTable> eventTableMap) {
        if (this.expiredEventChunk == null) {
            this.expiredEventChunk = new ComplexEventChunk(false);
        }
        return OperatorParser.constructOperator(this.expiredEventChunk, expression, matchingMetaStateHolder, executionPlanContext, variableExpressionExecutors, eventTableMap, this.queryName);
    }
}

