/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.output.ratelimit.snapshot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.query.output.ratelimit.snapshot.SnapshotOutputRateLimiter;
import org.wso2.siddhi.core.query.output.ratelimit.snapshot.WrappedSnapshotOutputRateLimiter;
import org.wso2.siddhi.core.util.Scheduler;
import org.wso2.siddhi.core.util.parser.SchedulerParser;

public class AggregationWindowedPerSnapshotOutputRateLimiter
extends SnapshotOutputRateLimiter {
    protected String id;
    protected final Long value;
    protected LinkedList<ComplexEvent> eventList;
    protected Comparator<ComplexEvent> comparator;
    protected final ScheduledExecutorService scheduledExecutorService;
    protected List<Integer> aggregateAttributePositionList;
    private Map<Integer, Object> aggregateAttributeValueMap;
    protected Scheduler scheduler;
    protected long scheduledTime;
    protected String queryName;

    protected AggregationWindowedPerSnapshotOutputRateLimiter(String id, Long value, ScheduledExecutorService scheduledExecutorService, final List<Integer> aggregateAttributePositionList, WrappedSnapshotOutputRateLimiter wrappedSnapshotOutputRateLimiter, ExecutionPlanContext executionPlanContext, String queryName) {
        super(wrappedSnapshotOutputRateLimiter, executionPlanContext);
        this.id = id;
        this.value = value;
        this.scheduledExecutorService = scheduledExecutorService;
        this.eventList = new LinkedList();
        this.aggregateAttributePositionList = aggregateAttributePositionList;
        this.queryName = queryName;
        Collections.sort(aggregateAttributePositionList);
        this.aggregateAttributeValueMap = new HashMap<Integer, Object>(aggregateAttributePositionList.size());
        this.comparator = new Comparator<ComplexEvent>(){
            Integer[] aggregateAttributePositions;
            int ignoreIndexLength;
            {
                this.aggregateAttributePositions = aggregateAttributePositionList.toArray(new Integer[aggregateAttributePositionList.size()]);
                this.ignoreIndexLength = this.aggregateAttributePositions.length;
            }

            @Override
            public int compare(ComplexEvent event1, ComplexEvent event2) {
                int ignoreIndex = 0;
                int ignoreIndexPosition = this.aggregateAttributePositions[0];
                Object[] data = event1.getOutputData();
                for (int i = 0; i < data.length; ++i) {
                    if (ignoreIndexPosition == i) {
                        if (++ignoreIndex == this.ignoreIndexLength) {
                            ignoreIndexPosition = -1;
                            continue;
                        }
                        ignoreIndexPosition = this.aggregateAttributePositions[i];
                        continue;
                    }
                    if (data[i].equals(event2.getOutputData()[i])) continue;
                    return 1;
                }
                return 0;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        complexEventChunk.reset();
        ArrayList<ComplexEventChunk<ComplexEvent>> outputEventChunks = new ArrayList<ComplexEventChunk<ComplexEvent>>();
        Object object = this;
        synchronized (object) {
            block2: while (complexEventChunk.hasNext()) {
                Object object2 = complexEventChunk.next();
                if (object2.getType() == ComplexEvent.Type.TIMER) {
                    this.tryFlushEvents(outputEventChunks, (ComplexEvent)object2);
                    continue;
                }
                complexEventChunk.remove();
                this.tryFlushEvents(outputEventChunks, (ComplexEvent)object2);
                if (object2.getType() == ComplexEvent.Type.CURRENT) {
                    this.eventList.add((ComplexEvent)object2);
                    for (Integer position : this.aggregateAttributePositionList) {
                        this.aggregateAttributeValueMap.put(position, object2.getOutputData()[position]);
                    }
                    continue;
                }
                if (object2.getType() == ComplexEvent.Type.EXPIRED) {
                    Iterator iterator = this.eventList.iterator();
                    while (iterator.hasNext()) {
                        ComplexEvent complexEvent = (ComplexEvent)iterator.next();
                        if (this.comparator.compare((ComplexEvent)object2, complexEvent) != 0) continue;
                        iterator.remove();
                        for (Integer position : this.aggregateAttributePositionList) {
                            this.aggregateAttributeValueMap.put(position, object2.getOutputData()[position]);
                        }
                        continue block2;
                    }
                    continue;
                }
                if (object2.getType() != ComplexEvent.Type.RESET) continue;
                this.eventList.clear();
                this.aggregateAttributeValueMap.clear();
            }
        }
        object = outputEventChunks.iterator();
        while (object.hasNext()) {
            ComplexEventChunk complexEventChunk2 = (ComplexEventChunk)object.next();
            this.sendToCallBacks(complexEventChunk2);
        }
        return;
    }

    private void tryFlushEvents(ArrayList<ComplexEventChunk<ComplexEvent>> outputEventChunks, ComplexEvent event) {
        if (event.getTimestamp() >= this.scheduledTime) {
            ComplexEventChunk<ComplexEvent> outputEventChunk = new ComplexEventChunk<ComplexEvent>(false);
            for (ComplexEvent originalComplexEvent : this.eventList) {
                ComplexEvent eventCopy = this.cloneComplexEvent(originalComplexEvent);
                for (Integer position : this.aggregateAttributePositionList) {
                    eventCopy.getOutputData()[position.intValue()] = this.aggregateAttributeValueMap.get(position);
                }
                outputEventChunk.add(eventCopy);
            }
            outputEventChunks.add(outputEventChunk);
            this.scheduledTime += this.value.longValue();
            this.scheduler.notifyAt(this.scheduledTime);
        }
    }

    @Override
    public void start() {
        this.scheduler = SchedulerParser.parse(this.scheduledExecutorService, this, this.executionPlanContext);
        this.scheduler.setStreamEventPool(new StreamEventPool(0, 0, 0, 5));
        this.scheduler.init(this.lockWrapper, this.queryName);
        long currentTime = System.currentTimeMillis();
        this.scheduledTime = currentTime + this.value;
        this.scheduler.notifyAt(this.scheduledTime);
    }

    @Override
    public void stop() {
    }

    @Override
    public Object[] currentState() {
        return new Object[]{this.eventList, this.aggregateAttributeValueMap};
    }

    @Override
    public void restoreState(Object[] state) {
        this.eventList = (LinkedList)state[0];
        this.aggregateAttributeValueMap = (Map)state[1];
    }

    @Override
    public SnapshotOutputRateLimiter clone(String key, WrappedSnapshotOutputRateLimiter wrappedSnapshotOutputRateLimiter) {
        return new AggregationWindowedPerSnapshotOutputRateLimiter(this.id + key, this.value, this.scheduledExecutorService, this.aggregateAttributePositionList, wrappedSnapshotOutputRateLimiter, this.executionPlanContext, this.queryName);
    }
}

