/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.output.callback;

import org.wso2.siddhi.core.debugger.SiddhiDebugger;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.state.StateEventPool;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.event.stream.converter.StreamEventConverter;
import org.wso2.siddhi.core.query.output.callback.OutputCallback;
import org.wso2.siddhi.core.table.EventTable;
import org.wso2.siddhi.core.util.collection.UpdateAttributeMapper;
import org.wso2.siddhi.core.util.collection.operator.Operator;
import org.wso2.siddhi.core.util.parser.MatcherParser;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;

public class UpdateTableCallback
extends OutputCallback {
    private final int matchingStreamIndex;
    private final UpdateAttributeMapper[] updateAttributeMappers;
    private EventTable eventTable;
    private Operator operator;
    private boolean convertToStreamEvent;
    private StateEventPool stateEventPool;
    private StreamEventPool streamEventPool;
    private StreamEventConverter streamEventConverter;

    public UpdateTableCallback(EventTable eventTable, Operator operator, AbstractDefinition updatingStreamDefinition, int matchingStreamIndex, boolean convertToStreamEvent, StateEventPool stateEventPool, StreamEventPool streamEventPool, StreamEventConverter streamEventConverter, String queryName) {
        super(queryName);
        this.eventTable = eventTable;
        this.operator = operator;
        this.matchingStreamIndex = matchingStreamIndex;
        this.convertToStreamEvent = convertToStreamEvent;
        this.stateEventPool = stateEventPool;
        this.streamEventPool = streamEventPool;
        this.streamEventConverter = streamEventConverter;
        this.updateAttributeMappers = MatcherParser.constructUpdateAttributeMapper((AbstractDefinition)eventTable.getTableDefinition(), updatingStreamDefinition.getAttributeList(), matchingStreamIndex);
    }

    @Override
    public synchronized void send(ComplexEventChunk updatingEventChunk) {
        if (this.getDebugger() != null) {
            this.getDebugger().checkBreakPoint(this.getQueryName(), SiddhiDebugger.QueryTerminal.OUT, (ComplexEvent)updatingEventChunk.getFirst());
        }
        updatingEventChunk.reset();
        if (updatingEventChunk.hasNext()) {
            ComplexEventChunk<StateEvent> updatingStateEventChunk = this.constructMatchingStateEventChunk(updatingEventChunk, this.convertToStreamEvent, this.stateEventPool, this.matchingStreamIndex, this.streamEventPool, this.streamEventConverter);
            this.eventTable.update(updatingStateEventChunk, this.operator, this.updateAttributeMappers);
        }
    }
}

