/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.input.stream.state;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.state.StateEventCloner;
import org.wso2.siddhi.core.event.state.StateEventPool;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.query.input.stream.state.PreStateProcessor;
import org.wso2.siddhi.core.query.input.stream.state.StreamPostStateProcessor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.util.snapshot.Snapshotable;
import org.wso2.siddhi.query.api.execution.query.input.stream.StateInputStream;

public class StreamPreStateProcessor
implements PreStateProcessor,
Snapshotable {
    protected int stateId;
    protected boolean isStartState;
    protected volatile boolean stateChanged = false;
    protected StateInputStream.Type stateType;
    protected List<Map.Entry<Long, Set<Integer>>> withinStates;
    protected ExecutionPlanContext executionPlanContext;
    protected String elementId;
    protected StreamPostStateProcessor thisStatePostProcessor;
    protected StreamPostStateProcessor thisLastProcessor;
    protected Processor nextProcessor;
    protected ComplexEventChunk<StateEvent> currentStateEventChunk = new ComplexEventChunk(false);
    protected LinkedList<StateEvent> pendingStateEventList = new LinkedList();
    protected LinkedList<StateEvent> newAndEveryStateEventList = new LinkedList();
    protected StateEventPool stateEventPool;
    protected StreamEventCloner streamEventCloner;
    protected StateEventCloner stateEventCloner;
    protected StreamEventPool streamEventPool;
    protected String queryName;

    public StreamPreStateProcessor(StateInputStream.Type stateType, List<Map.Entry<Long, Set<Integer>>> withinStates) {
        this.stateType = stateType;
        this.withinStates = withinStates;
    }

    public void init(ExecutionPlanContext executionPlanContext, String queryName) {
        this.executionPlanContext = executionPlanContext;
        this.queryName = queryName;
        if (this.elementId == null) {
            this.elementId = "StreamPreStateProcessor-" + executionPlanContext.getElementIdGenerator().createNewId();
        }
        executionPlanContext.getSnapshotService().addSnapshotable(queryName, this);
    }

    public void setThisStatePostProcessor(StreamPostStateProcessor thisStatePostProcessor) {
        this.thisStatePostProcessor = thisStatePostProcessor;
    }

    @Override
    public StreamPostStateProcessor getThisStatePostProcessor() {
        return this.thisStatePostProcessor;
    }

    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        throw new IllegalStateException("process method of StreamPreStateProcessor should not be called. processAndReturn method is used for handling event chunks.");
    }

    private boolean isExpired(StateEvent pendingStateEvent, StreamEvent incomingStreamEvent) {
        for (Map.Entry<Long, Set<Integer>> withinEntry : this.withinStates) {
            for (Integer withinStateId : withinEntry.getValue()) {
                if (!(withinStateId == -1 ? Math.abs(pendingStateEvent.getTimestamp() - incomingStreamEvent.getTimestamp()) > withinEntry.getKey() : Math.abs(pendingStateEvent.getStreamEvent(withinStateId).getTimestamp() - incomingStreamEvent.getTimestamp()) > withinEntry.getKey())) continue;
                return true;
            }
        }
        return false;
    }

    protected void process(StateEvent stateEvent) {
        this.currentStateEventChunk.add(stateEvent);
        this.currentStateEventChunk.reset();
        this.stateChanged = false;
        this.nextProcessor.process(this.currentStateEventChunk);
        this.currentStateEventChunk.reset();
    }

    @Override
    public Processor getNextProcessor() {
        return this.nextProcessor;
    }

    @Override
    public void setNextProcessor(Processor processor) {
        this.nextProcessor = processor;
    }

    @Override
    public void setToLast(Processor processor) {
        if (this.nextProcessor == null) {
            this.nextProcessor = processor;
        } else {
            this.nextProcessor.setToLast(processor);
        }
    }

    @Override
    public void init() {
        if (this.isStartState) {
            StateEvent stateEvent = this.stateEventPool.borrowEvent();
            this.addState(stateEvent);
        }
    }

    public StreamPostStateProcessor getThisLastProcessor() {
        return this.thisLastProcessor;
    }

    public void setThisLastProcessor(StreamPostStateProcessor thisLastProcessor) {
        this.thisLastProcessor = thisLastProcessor;
    }

    @Override
    public PreStateProcessor cloneProcessor(String key) {
        StreamPreStateProcessor streamPreStateProcessor = new StreamPreStateProcessor(this.stateType, this.withinStates);
        this.cloneProperties(streamPreStateProcessor, key);
        streamPreStateProcessor.init(this.executionPlanContext, this.queryName);
        return streamPreStateProcessor;
    }

    protected void cloneProperties(StreamPreStateProcessor streamPreStateProcessor, String key) {
        streamPreStateProcessor.stateId = this.stateId;
        streamPreStateProcessor.elementId = this.elementId + "-" + key;
        streamPreStateProcessor.stateEventPool = this.stateEventPool;
        streamPreStateProcessor.streamEventCloner = this.streamEventCloner;
        streamPreStateProcessor.stateEventCloner = this.stateEventCloner;
        streamPreStateProcessor.streamEventPool = this.streamEventPool;
    }

    @Override
    public void addState(StateEvent stateEvent) {
        if (this.stateType == StateInputStream.Type.SEQUENCE) {
            if (this.newAndEveryStateEventList.isEmpty()) {
                this.newAndEveryStateEventList.add(stateEvent);
            }
        } else {
            this.newAndEveryStateEventList.add(stateEvent);
        }
    }

    @Override
    public void addEveryState(StateEvent stateEvent) {
        this.newAndEveryStateEventList.add(this.stateEventCloner.copyStateEvent(stateEvent));
    }

    public void stateChanged() {
        this.stateChanged = true;
    }

    @Override
    public void setStartState(boolean isStartState) {
        this.isStartState = isStartState;
    }

    public void setStateEventPool(StateEventPool stateEventPool) {
        this.stateEventPool = stateEventPool;
    }

    public void setStreamEventPool(StreamEventPool streamEventPool) {
        this.streamEventPool = streamEventPool;
    }

    public void setStreamEventCloner(StreamEventCloner streamEventCloner) {
        this.streamEventCloner = streamEventCloner;
    }

    public void setStateEventCloner(StateEventCloner stateEventCloner) {
        this.stateEventCloner = stateEventCloner;
    }

    @Override
    public void resetState() {
        this.pendingStateEventList.clear();
        if (this.isStartState && this.newAndEveryStateEventList.isEmpty()) {
            this.init();
        }
    }

    @Override
    public void updateState() {
        this.pendingStateEventList.addAll(this.newAndEveryStateEventList);
        this.newAndEveryStateEventList.clear();
    }

    @Override
    public void setStateId(int stateId) {
        this.stateId = stateId;
    }

    @Override
    public ComplexEventChunk<StateEvent> processAndReturn(ComplexEventChunk complexEventChunk) {
        ComplexEventChunk<StateEvent> returnEventChunk = new ComplexEventChunk<StateEvent>(false);
        complexEventChunk.reset();
        StreamEvent streamEvent = (StreamEvent)complexEventChunk.next();
        Iterator iterator = this.pendingStateEventList.iterator();
        while (iterator.hasNext()) {
            StateEvent stateEvent = (StateEvent)iterator.next();
            if (this.withinStates.size() > 0 && this.isExpired(stateEvent, streamEvent)) {
                iterator.remove();
                continue;
            }
            stateEvent.setEvent(this.stateId, this.streamEventCloner.copyStreamEvent(streamEvent));
            this.process(stateEvent);
            if (this.thisLastProcessor.isEventReturned()) {
                this.thisLastProcessor.clearProcessedEvent();
                returnEventChunk.add(stateEvent);
            }
            if (this.stateChanged) {
                iterator.remove();
                continue;
            }
            switch (this.stateType) {
                case PATTERN: {
                    stateEvent.setEvent(this.stateId, null);
                    break;
                }
                case SEQUENCE: {
                    stateEvent.setEvent(this.stateId, null);
                    iterator.remove();
                    if (this.thisStatePostProcessor.callbackPreStateProcessor == null) break;
                    this.thisStatePostProcessor.callbackPreStateProcessor.startStateReset();
                }
            }
        }
        return returnEventChunk;
    }

    @Override
    public int getStateId() {
        return this.stateId;
    }

    @Override
    public Object[] currentState() {
        return new Object[]{this.currentStateEventChunk, this.pendingStateEventList, this.newAndEveryStateEventList};
    }

    @Override
    public void restoreState(Object[] state) {
        this.currentStateEventChunk = (ComplexEventChunk)state[0];
        this.pendingStateEventList = (LinkedList)state[1];
        this.newAndEveryStateEventList = (LinkedList)state[2];
    }

    @Override
    public String getElementId() {
        return this.elementId;
    }
}

