/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.input.stream.state;

import java.util.List;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.MetaComplexEvent;
import org.wso2.siddhi.core.event.state.MetaStateEvent;
import org.wso2.siddhi.core.query.input.ProcessStreamReceiver;
import org.wso2.siddhi.core.query.input.stream.StreamRuntime;
import org.wso2.siddhi.core.query.input.stream.single.SingleStreamRuntime;
import org.wso2.siddhi.core.query.input.stream.state.StreamPostStateProcessor;
import org.wso2.siddhi.core.query.input.stream.state.StreamPreStateProcessor;
import org.wso2.siddhi.core.query.input.stream.state.receiver.SequenceMultiProcessStreamReceiver;
import org.wso2.siddhi.core.query.input.stream.state.receiver.SequenceSingleProcessStreamReceiver;
import org.wso2.siddhi.core.query.input.stream.state.runtime.InnerStateRuntime;
import org.wso2.siddhi.core.query.processor.Processor;

public class StateStreamRuntime
implements StreamRuntime {
    private ExecutionPlanContext executionPlanContext;
    private MetaStateEvent metaStateEvent;
    private InnerStateRuntime innerStateRuntime;

    public StateStreamRuntime(ExecutionPlanContext executionPlanContext, MetaStateEvent metaStateEvent) {
        this.executionPlanContext = executionPlanContext;
        this.metaStateEvent = metaStateEvent;
    }

    @Override
    public List<SingleStreamRuntime> getSingleStreamRuntimes() {
        return this.innerStateRuntime.getSingleStreamRuntimeList();
    }

    @Override
    public StreamRuntime clone(String key) {
        StateStreamRuntime stateStreamRuntime = new StateStreamRuntime(this.executionPlanContext, this.metaStateEvent);
        stateStreamRuntime.innerStateRuntime = this.innerStateRuntime.clone(key);
        for (SingleStreamRuntime singleStreamRuntime : stateStreamRuntime.getSingleStreamRuntimes()) {
            ProcessStreamReceiver processStreamReceiver = singleStreamRuntime.getProcessStreamReceiver();
            if (processStreamReceiver instanceof SequenceMultiProcessStreamReceiver) {
                ((SequenceMultiProcessStreamReceiver)processStreamReceiver).setStateStreamRuntime(stateStreamRuntime);
                continue;
            }
            if (!(processStreamReceiver instanceof SequenceSingleProcessStreamReceiver)) continue;
            ((SequenceSingleProcessStreamReceiver)processStreamReceiver).setStateStreamRuntime(stateStreamRuntime);
        }
        ((StreamPreStateProcessor)stateStreamRuntime.innerStateRuntime.getFirstProcessor()).setThisLastProcessor((StreamPostStateProcessor)stateStreamRuntime.innerStateRuntime.getLastProcessor());
        return stateStreamRuntime;
    }

    @Override
    public void setCommonProcessor(Processor commonProcessor) {
        this.innerStateRuntime.setQuerySelector(commonProcessor);
        this.innerStateRuntime.setStartState();
        this.innerStateRuntime.init();
    }

    @Override
    public MetaComplexEvent getMetaComplexEvent() {
        return this.metaStateEvent;
    }

    public void setInnerStateRuntime(InnerStateRuntime innerStateRuntime) {
        this.innerStateRuntime = innerStateRuntime;
    }

    public void resetAndUpdate() {
        this.innerStateRuntime.reset();
        this.innerStateRuntime.update();
    }
}

