/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.executor.condition;

import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.condition.ConditionExpressionExecutor;
import org.wso2.siddhi.core.table.EventTable;
import org.wso2.siddhi.core.util.collection.FinderStateEvent;
import org.wso2.siddhi.core.util.collection.operator.Finder;

public class InConditionExpressionExecutor
extends ConditionExpressionExecutor {
    private final int streamEventSize;
    private final boolean isMatchingEventAStateEvent;
    private final int matchingStreamIndex;
    private EventTable eventTable;
    private final Finder finder;
    private FinderStateEvent finderStateEvent;

    public InConditionExpressionExecutor(EventTable eventTable, Finder finder, int streamEventSize, boolean isMatchingEventAStateEvent, int matchingStreamIndex) {
        this.streamEventSize = streamEventSize;
        this.isMatchingEventAStateEvent = isMatchingEventAStateEvent;
        this.matchingStreamIndex = matchingStreamIndex;
        this.finderStateEvent = new FinderStateEvent(streamEventSize, 0);
        this.eventTable = eventTable;
        this.finder = finder;
    }

    @Override
    public synchronized Boolean execute(ComplexEvent event) {
        try {
            if (this.isMatchingEventAStateEvent) {
                this.finderStateEvent.setEvent((StateEvent)event);
            } else {
                this.finderStateEvent.setEvent(this.matchingStreamIndex, (StreamEvent)event);
            }
            Boolean bl = this.eventTable.contains(this.finderStateEvent, this.finder);
            return bl;
        }
        finally {
            if (this.isMatchingEventAStateEvent) {
                this.finderStateEvent.setEvent(null);
            } else {
                this.finderStateEvent.setEvent(this.matchingStreamIndex, null);
            }
        }
    }

    @Override
    public ExpressionExecutor cloneExecutor(String key) {
        return new InConditionExpressionExecutor(this.eventTable, this.finder.cloneFinder(key), this.streamEventSize, this.isMatchingEventAStateEvent, this.matchingStreamIndex);
    }
}

