/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.event.stream.populater;

import java.util.List;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.populater.ComplexEventPopulater;
import org.wso2.siddhi.core.event.stream.populater.StreamMappingElement;

public class SelectiveComplexEventPopulater
implements ComplexEventPopulater {
    private List<StreamMappingElement> streamMappingElements;

    public SelectiveComplexEventPopulater(List<StreamMappingElement> streamMappingElements) {
        this.streamMappingElements = streamMappingElements;
    }

    @Override
    public void populateComplexEvent(ComplexEvent complexEvent, Object[] data) {
        for (StreamMappingElement mappingElement : this.streamMappingElements) {
            this.populateStreamEvent(complexEvent, data[mappingElement.getFromPosition()], mappingElement.getToPosition());
        }
    }

    private void populateStreamEvent(ComplexEvent complexEvent, Object data, int[] toPosition) {
        StreamEvent streamEvent;
        if (toPosition == null) {
            return;
        }
        if (complexEvent instanceof StreamEvent) {
            streamEvent = (StreamEvent)complexEvent;
        } else {
            streamEvent = ((StateEvent)complexEvent).getStreamEvent(toPosition[0]);
            for (int i = 0; i <= toPosition[1]; ++i) {
                streamEvent = streamEvent.getNext();
            }
        }
        switch (toPosition[2]) {
            case 0: {
                streamEvent.setBeforeWindowData(data, toPosition[3]);
                break;
            }
            case 1: {
                streamEvent.setOnAfterWindowData(data, toPosition[3]);
                break;
            }
            case 2: {
                complexEvent.setOutputData(data, toPosition[3]);
                break;
            }
            default: {
                throw new IllegalStateException("To Position cannot be :" + toPosition);
            }
        }
    }
}

