/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.collection.operator;

import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.table.holder.PrimaryKeyEventHolder;
import org.wso2.siddhi.core.util.collection.OverwritingStreamEventExtractor;
import org.wso2.siddhi.core.util.collection.UpdateAttributeMapper;
import org.wso2.siddhi.core.util.collection.operator.Finder;
import org.wso2.siddhi.core.util.collection.operator.Operator;

public class PrimaryKeyOperator
implements Operator {
    private final ExpressionExecutor expressionExecutor;
    private final int candidateEventPosition;
    private final int indexPosition;

    public PrimaryKeyOperator(ExpressionExecutor expressionExecutor, int candidateEventPosition, int indexPosition) {
        this.expressionExecutor = expressionExecutor;
        this.candidateEventPosition = candidateEventPosition;
        this.indexPosition = indexPosition;
    }

    @Override
    public Finder cloneFinder(String key) {
        return new PrimaryKeyOperator(this.expressionExecutor.cloneExecutor(key), this.candidateEventPosition, this.indexPosition);
    }

    @Override
    public StreamEvent find(StateEvent matchingEvent, Object candidateEvents, StreamEventCloner candidateEventCloner) {
        Object matchingKey = this.expressionExecutor.execute(matchingEvent);
        StreamEvent streamEvent = (StreamEvent)((PrimaryKeyEventHolder)candidateEvents).get(matchingKey);
        if (streamEvent == null) {
            return null;
        }
        return candidateEventCloner.copyStreamEvent(streamEvent);
    }

    @Override
    public boolean contains(StateEvent matchingEvent, Object candidateEvents) {
        Object matchingKey = this.expressionExecutor.execute(matchingEvent);
        StreamEvent streamEvent = (StreamEvent)((PrimaryKeyEventHolder)candidateEvents).get(matchingKey);
        return streamEvent != null;
    }

    @Override
    public void delete(ComplexEventChunk<StateEvent> deletingEventChunk, Object candidateEvents) {
        deletingEventChunk.reset();
        while (deletingEventChunk.hasNext()) {
            StateEvent deletingEvent = (StateEvent)deletingEventChunk.next();
            Object matchingKey = this.expressionExecutor.execute(deletingEvent);
            ((PrimaryKeyEventHolder)candidateEvents).remove(matchingKey);
        }
    }

    @Override
    public void update(ComplexEventChunk<StateEvent> updatingEventChunk, Object candidateEvents, UpdateAttributeMapper[] updateAttributeMappers) {
        updatingEventChunk.reset();
        while (updatingEventChunk.hasNext()) {
            StateEvent updatingEvent = (StateEvent)updatingEventChunk.next();
            Object matchingKey = this.expressionExecutor.execute(updatingEvent);
            StreamEvent streamEvent = (StreamEvent)((PrimaryKeyEventHolder)candidateEvents).get(matchingKey);
            if (streamEvent == null) continue;
            for (UpdateAttributeMapper updateAttributeMapper : updateAttributeMappers) {
                streamEvent.setOutputData(updateAttributeMapper.getOutputData(updatingEvent), updateAttributeMapper.getCandidateAttributePosition());
            }
        }
    }

    @Override
    public ComplexEventChunk<StreamEvent> overwriteOrAdd(ComplexEventChunk<StateEvent> overwritingOrAddingEventChunk, Object candidateEvents, UpdateAttributeMapper[] updateAttributeMappers, OverwritingStreamEventExtractor overwritingStreamEventExtractor) {
        overwritingOrAddingEventChunk.reset();
        ComplexEventChunk<StreamEvent> failedEventChunk = new ComplexEventChunk<StreamEvent>(overwritingOrAddingEventChunk.isBatch());
        while (overwritingOrAddingEventChunk.hasNext()) {
            StateEvent overwritingOrAddingEvent = (StateEvent)overwritingOrAddingEventChunk.next();
            Object matchingKey = this.expressionExecutor.execute(overwritingOrAddingEvent);
            StreamEvent streamEvent = (StreamEvent)((PrimaryKeyEventHolder)candidateEvents).get(matchingKey);
            if (streamEvent != null) {
                for (UpdateAttributeMapper updateAttributeMapper : updateAttributeMappers) {
                    streamEvent.setOutputData(updateAttributeMapper.getOutputData(overwritingOrAddingEvent), updateAttributeMapper.getCandidateAttributePosition());
                }
                continue;
            }
            failedEventChunk.add(overwritingStreamEventExtractor.getOverwritingStreamEvent(overwritingOrAddingEvent));
        }
        return failedEventChunk;
    }
}

