/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.collection.operator;

import java.util.Collection;
import java.util.Iterator;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.util.collection.OverwritingStreamEventExtractor;
import org.wso2.siddhi.core.util.collection.UpdateAttributeMapper;
import org.wso2.siddhi.core.util.collection.operator.Finder;
import org.wso2.siddhi.core.util.collection.operator.Operator;

public class CollectionOperator
implements Operator {
    protected ExpressionExecutor expressionExecutor;
    protected int candidateEventPosition;

    public CollectionOperator(ExpressionExecutor expressionExecutor, int candidateEventPosition) {
        this.expressionExecutor = expressionExecutor;
        this.candidateEventPosition = candidateEventPosition;
    }

    @Override
    public Finder cloneFinder(String key) {
        return new CollectionOperator(this.expressionExecutor.cloneExecutor(key), this.candidateEventPosition);
    }

    @Override
    public StreamEvent find(StateEvent matchingEvent, Object candidateEvents, StreamEventCloner candidateEventCloner) {
        ComplexEventChunk<StreamEvent> returnEventChunk = new ComplexEventChunk<StreamEvent>(false);
        for (StreamEvent candidateEvent : (Collection)candidateEvents) {
            matchingEvent.setEvent(this.candidateEventPosition, candidateEvent);
            if (((Boolean)this.expressionExecutor.execute(matchingEvent)).booleanValue()) {
                returnEventChunk.add(candidateEventCloner.copyStreamEvent(candidateEvent));
            }
            matchingEvent.setEvent(this.candidateEventPosition, null);
        }
        return (StreamEvent)returnEventChunk.getFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(StateEvent matchingEvent, Object candidateEvents) {
        try {
            for (StreamEvent candidateEvent : (Collection)candidateEvents) {
                matchingEvent.setEvent(this.candidateEventPosition, candidateEvent);
                if (!((Boolean)this.expressionExecutor.execute(matchingEvent)).booleanValue()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            matchingEvent.setEvent(this.candidateEventPosition, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(ComplexEventChunk<StateEvent> deletingEventChunk, Object candidateEvents) {
        if (((Collection)candidateEvents).size() > 0) {
            deletingEventChunk.reset();
            while (deletingEventChunk.hasNext()) {
                StateEvent deletingEvent = (StateEvent)deletingEventChunk.next();
                try {
                    Iterator iterator = ((Collection)candidateEvents).iterator();
                    while (iterator.hasNext()) {
                        StreamEvent candidateEvent = (StreamEvent)iterator.next();
                        deletingEvent.setEvent(this.candidateEventPosition, candidateEvent);
                        if (!((Boolean)this.expressionExecutor.execute(deletingEvent)).booleanValue()) continue;
                        iterator.remove();
                    }
                }
                finally {
                    deletingEvent.setEvent(this.candidateEventPosition, null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(ComplexEventChunk<StateEvent> updatingEventChunk, Object candidateEvents, UpdateAttributeMapper[] updateAttributeMappers) {
        if (((Collection)candidateEvents).size() > 0) {
            updatingEventChunk.reset();
            while (updatingEventChunk.hasNext()) {
                StateEvent updatingEvent = (StateEvent)updatingEventChunk.next();
                try {
                    for (StreamEvent candidateEvent : (Collection)candidateEvents) {
                        updatingEvent.setEvent(this.candidateEventPosition, candidateEvent);
                        if (!((Boolean)this.expressionExecutor.execute(updatingEvent)).booleanValue()) continue;
                        for (UpdateAttributeMapper updateAttributeMapper : updateAttributeMappers) {
                            candidateEvent.setOutputData(updateAttributeMapper.getOutputData(updatingEvent), updateAttributeMapper.getCandidateAttributePosition());
                        }
                    }
                }
                finally {
                    updatingEvent.setEvent(this.candidateEventPosition, null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComplexEventChunk<StreamEvent> overwriteOrAdd(ComplexEventChunk<StateEvent> overwritingOrAddingEventChunk, Object candidateEvents, UpdateAttributeMapper[] updateAttributeMappers, OverwritingStreamEventExtractor overwritingStreamEventExtractor) {
        overwritingOrAddingEventChunk.reset();
        ComplexEventChunk<StreamEvent> failedEventChunk = new ComplexEventChunk<StreamEvent>(overwritingOrAddingEventChunk.isBatch());
        while (overwritingOrAddingEventChunk.hasNext()) {
            StateEvent overwritingOrAddingEvent = (StateEvent)overwritingOrAddingEventChunk.next();
            try {
                boolean updated = false;
                if (((Collection)candidateEvents).size() > 0) {
                    for (StreamEvent candidateEvent : (Collection)candidateEvents) {
                        overwritingOrAddingEvent.setEvent(this.candidateEventPosition, candidateEvent);
                        if (!((Boolean)this.expressionExecutor.execute(overwritingOrAddingEvent)).booleanValue()) continue;
                        for (UpdateAttributeMapper updateAttributeMapper : updateAttributeMappers) {
                            candidateEvent.setOutputData(updateAttributeMapper.getOutputData(overwritingOrAddingEvent), updateAttributeMapper.getCandidateAttributePosition());
                        }
                        updated = true;
                    }
                }
                if (updated) continue;
                failedEventChunk.add(overwritingStreamEventExtractor.getOverwritingStreamEvent(overwritingOrAddingEvent));
            }
            finally {
                overwritingOrAddingEvent.setEvent(this.candidateEventPosition, null);
            }
        }
        return failedEventChunk;
    }
}

