/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.selector.attribute.aggregator;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.exception.OperationNotSupportedException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.query.selector.attribute.aggregator.AttributeAggregator;
import org.wso2.siddhi.query.api.definition.Attribute;

public class AvgAttributeAggregator
extends AttributeAggregator {
    private AvgAttributeAggregator avgOutputAttributeAggregator;

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new OperationNotSupportedException("Avg aggregator has to have exactly 1 parameter, currently " + attributeExpressionExecutors.length + " parameters provided");
        }
        Attribute.Type type = attributeExpressionExecutors[0].getReturnType();
        switch (type) {
            case FLOAT: {
                this.avgOutputAttributeAggregator = new AvgAttributeAggregatorFloat();
                break;
            }
            case INT: {
                this.avgOutputAttributeAggregator = new AvgAttributeAggregatorInt();
                break;
            }
            case LONG: {
                this.avgOutputAttributeAggregator = new AvgAttributeAggregatorLong();
                break;
            }
            case DOUBLE: {
                this.avgOutputAttributeAggregator = new AvgAttributeAggregatorDouble();
                break;
            }
            default: {
                throw new OperationNotSupportedException("Avg not supported for " + type);
            }
        }
    }

    @Override
    public Attribute.Type getReturnType() {
        return this.avgOutputAttributeAggregator.getReturnType();
    }

    @Override
    public Object processAdd(Object data) {
        return this.avgOutputAttributeAggregator.processAdd(data);
    }

    @Override
    public Object processAdd(Object[] data) {
        return new IllegalStateException("Avg cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object processRemove(Object data) {
        return this.avgOutputAttributeAggregator.processRemove(data);
    }

    @Override
    public Object processRemove(Object[] data) {
        return new IllegalStateException("Avg cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object reset() {
        return this.avgOutputAttributeAggregator.reset();
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Object[] currentState() {
        return this.avgOutputAttributeAggregator.currentState();
    }

    @Override
    public void restoreState(Object[] state) {
        this.avgOutputAttributeAggregator.restoreState(state);
    }

    class AvgAttributeAggregatorLong
    extends AvgAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.DOUBLE;
        private double value = 0.0;
        private long count = 0L;

        AvgAttributeAggregatorLong() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public Object processAdd(Object data) {
            ++this.count;
            this.value += (double)((Long)data).longValue();
            if (this.count == 0L) {
                return 0.0;
            }
            return this.value / (double)this.count;
        }

        @Override
        public Object processRemove(Object obj) {
            --this.count;
            this.value -= (double)((Long)obj).longValue();
            if (this.count == 0L) {
                return 0.0;
            }
            return this.value / (double)this.count;
        }

        @Override
        public Object reset() {
            this.value = 0.0;
            this.count = 0L;
            return 0.0;
        }

        @Override
        public Object[] currentState() {
            return new Object[]{new AbstractMap.SimpleEntry<String, Double>("Value", this.value), new AbstractMap.SimpleEntry<String, Long>("Count", this.count)};
        }

        @Override
        public void restoreState(Object[] state) {
            Map.Entry stateEntry = (Map.Entry)state[0];
            this.value = (Double)stateEntry.getValue();
            Map.Entry stateEntry2 = (Map.Entry)state[1];
            this.count = (Long)stateEntry2.getValue();
        }
    }

    class AvgAttributeAggregatorInt
    extends AvgAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.DOUBLE;
        private double value = 0.0;
        private long count = 0L;

        AvgAttributeAggregatorInt() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public Object processAdd(Object data) {
            ++this.count;
            this.value += (double)((Integer)data).intValue();
            if (this.count == 0L) {
                return 0.0;
            }
            return this.value / (double)this.count;
        }

        @Override
        public Object processRemove(Object obj) {
            --this.count;
            this.value -= (double)((Integer)obj).intValue();
            if (this.count == 0L) {
                return 0.0;
            }
            return this.value / (double)this.count;
        }

        @Override
        public Object reset() {
            this.value = 0.0;
            this.count = 0L;
            return 0.0;
        }

        @Override
        public Object[] currentState() {
            return new Object[]{new AbstractMap.SimpleEntry<String, Double>("Value", this.value), new AbstractMap.SimpleEntry<String, Long>("Count", this.count)};
        }

        @Override
        public void restoreState(Object[] state) {
            Map.Entry stateEntry = (Map.Entry)state[0];
            this.value = (Double)stateEntry.getValue();
            Map.Entry stateEntry2 = (Map.Entry)state[1];
            this.count = (Long)stateEntry2.getValue();
        }
    }

    class AvgAttributeAggregatorFloat
    extends AvgAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.DOUBLE;
        private double value = 0.0;
        private long count = 0L;

        AvgAttributeAggregatorFloat() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public Object processAdd(Object data) {
            ++this.count;
            this.value += (double)((Float)data).floatValue();
            if (this.count == 0L) {
                return 0.0;
            }
            return this.value / (double)this.count;
        }

        @Override
        public Object processRemove(Object obj) {
            --this.count;
            this.value -= (double)((Float)obj).floatValue();
            if (this.count == 0L) {
                return 0.0;
            }
            return this.value / (double)this.count;
        }

        @Override
        public Object reset() {
            this.value = 0.0;
            this.count = 0L;
            return 0.0;
        }

        @Override
        public Object[] currentState() {
            return new Object[]{new AbstractMap.SimpleEntry<String, Double>("Value", this.value), new AbstractMap.SimpleEntry<String, Long>("Count", this.count)};
        }

        @Override
        public void restoreState(Object[] state) {
            Map.Entry stateEntry = (Map.Entry)state[0];
            this.value = (Double)stateEntry.getValue();
            Map.Entry stateEntry2 = (Map.Entry)state[1];
            this.count = (Long)stateEntry2.getValue();
        }
    }

    class AvgAttributeAggregatorDouble
    extends AvgAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.DOUBLE;
        private double value = 0.0;
        private long count = 0L;

        AvgAttributeAggregatorDouble() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public Object processAdd(Object data) {
            ++this.count;
            this.value += ((Double)data).doubleValue();
            if (this.count == 0L) {
                return 0.0;
            }
            return this.value / (double)this.count;
        }

        @Override
        public Object processRemove(Object obj) {
            --this.count;
            this.value -= ((Double)obj).doubleValue();
            if (this.count == 0L) {
                return 0.0;
            }
            return this.value / (double)this.count;
        }

        @Override
        public Object reset() {
            this.value = 0.0;
            this.count = 0L;
            return 0.0;
        }

        @Override
        public Object[] currentState() {
            return new Object[]{new AbstractMap.SimpleEntry<String, Double>("Value", this.value), new AbstractMap.SimpleEntry<String, Long>("Count", this.count)};
        }

        @Override
        public void restoreState(Object[] state) {
            Map.Entry stateEntry = (Map.Entry)state[0];
            this.value = (Double)stateEntry.getValue();
            Map.Entry stateEntry2 = (Map.Entry)state[1];
            this.count = (Long)stateEntry2.getValue();
        }
    }
}

