/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.ExecutionPlanRuntime;
import org.wso2.siddhi.core.config.SiddhiContext;
import org.wso2.siddhi.core.config.StatisticsConfiguration;
import org.wso2.siddhi.core.util.ExecutionPlanRuntimeBuilder;
import org.wso2.siddhi.core.util.parser.ExecutionPlanParser;
import org.wso2.siddhi.core.util.persistence.PersistenceStore;
import org.wso2.siddhi.core.util.snapshot.SnapshotService;
import org.wso2.siddhi.query.api.ExecutionPlan;
import org.wso2.siddhi.query.compiler.SiddhiCompiler;

public class SiddhiManager {
    private static final Logger LOGGER = Logger.getLogger(SiddhiManager.class);
    private SiddhiContext siddhiContext;
    private ConcurrentMap<String, ExecutionPlanRuntime> executionPlanRuntimeMap = new ConcurrentHashMap<String, ExecutionPlanRuntime>();

    public SiddhiManager() {
        this.siddhiContext = new SiddhiContext();
    }

    public ExecutionPlanRuntime createExecutionPlanRuntime(ExecutionPlan executionPlan) {
        ExecutionPlanRuntimeBuilder executionPlanRuntimeBuilder = ExecutionPlanParser.parse(executionPlan, this.siddhiContext);
        executionPlanRuntimeBuilder.setExecutionPlanRuntimeMap(this.executionPlanRuntimeMap);
        ExecutionPlanRuntime executionPlanRuntime = executionPlanRuntimeBuilder.build();
        this.executionPlanRuntimeMap.put(executionPlanRuntime.getName(), executionPlanRuntime);
        return executionPlanRuntime;
    }

    public ExecutionPlanRuntime createExecutionPlanRuntime(String executionPlan) {
        return this.createExecutionPlanRuntime(SiddhiCompiler.parse((String)executionPlan));
    }

    public ExecutionPlanRuntime getExecutionPlanRuntime(String executionPlanName) {
        return (ExecutionPlanRuntime)this.executionPlanRuntimeMap.get(executionPlanName);
    }

    public void validateExecutionPlan(ExecutionPlan executionPlan) {
        ExecutionPlanRuntime executionPlanRuntime = ExecutionPlanParser.parse(executionPlan, this.siddhiContext).build();
        executionPlanRuntime.start();
        executionPlanRuntime.shutdown();
    }

    public void validateExecutionPlan(String executionPlan) {
        this.validateExecutionPlan(SiddhiCompiler.parse((String)executionPlan));
    }

    public void setPersistenceStore(PersistenceStore persistenceStore) {
        this.siddhiContext.setPersistenceStore(persistenceStore);
    }

    public void setExtension(String name, Class clazz) {
        this.siddhiContext.getSiddhiExtensions().put(name, clazz);
    }

    public void setDataSource(String dataSourceName, DataSource dataSource) {
        this.siddhiContext.addSiddhiDataSource(dataSourceName, dataSource);
    }

    public void setStatisticsConfiguration(StatisticsConfiguration statisticsConfiguration) {
        this.siddhiContext.setStatisticsConfiguration(statisticsConfiguration);
    }

    public void shutdown() {
        ArrayList executionPlanNames = new ArrayList(this.executionPlanRuntimeMap.keySet());
        for (String executionPlanName : executionPlanNames) {
            ((ExecutionPlanRuntime)this.executionPlanRuntimeMap.get(executionPlanName)).shutdown();
        }
    }

    public void persist() {
        for (ExecutionPlanRuntime executionPlanRuntime : this.executionPlanRuntimeMap.values()) {
            executionPlanRuntime.persist();
        }
        SnapshotService.persistSnapshotableElements();
    }

    public void restoreLastState() {
        for (ExecutionPlanRuntime executionPlanRuntime : this.executionPlanRuntimeMap.values()) {
            executionPlanRuntime.restoreLastRevision();
        }
        SnapshotService.restoreSnapshotableElements();
    }
}

