/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core;

import com.lmax.disruptor.ExceptionHandler;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.debugger.SiddhiDebugger;
import org.wso2.siddhi.core.exception.DefinitionNotExistException;
import org.wso2.siddhi.core.exception.QueryNotExistException;
import org.wso2.siddhi.core.partition.PartitionRuntime;
import org.wso2.siddhi.core.query.QueryRuntime;
import org.wso2.siddhi.core.query.input.stream.StreamRuntime;
import org.wso2.siddhi.core.query.input.stream.single.SingleStreamRuntime;
import org.wso2.siddhi.core.query.output.callback.OutputCallback;
import org.wso2.siddhi.core.query.output.callback.QueryCallback;
import org.wso2.siddhi.core.stream.StreamJunction;
import org.wso2.siddhi.core.stream.input.InputHandler;
import org.wso2.siddhi.core.stream.input.InputManager;
import org.wso2.siddhi.core.stream.output.StreamCallback;
import org.wso2.siddhi.core.table.EventTable;
import org.wso2.siddhi.core.util.extension.holder.EternalReferencedHolder;
import org.wso2.siddhi.core.util.statistics.MemoryUsageTracker;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;

public class ExecutionPlanRuntime {
    private static final Logger log = Logger.getLogger(ExecutionPlanRuntime.class);
    private ConcurrentMap<String, AbstractDefinition> streamDefinitionMap = new ConcurrentHashMap<String, AbstractDefinition>();
    private ConcurrentMap<String, AbstractDefinition> tableDefinitionMap = new ConcurrentHashMap<String, AbstractDefinition>();
    private InputManager inputManager;
    private ConcurrentMap<String, QueryRuntime> queryProcessorMap = new ConcurrentHashMap<String, QueryRuntime>();
    private ConcurrentMap<String, StreamJunction> streamJunctionMap = new ConcurrentHashMap<String, StreamJunction>();
    private ConcurrentMap<String, EventTable> eventTableMap = new ConcurrentHashMap<String, EventTable>();
    private ConcurrentMap<String, PartitionRuntime> partitionMap = new ConcurrentHashMap<String, PartitionRuntime>();
    private ExecutionPlanContext executionPlanContext;
    private ConcurrentMap<String, ExecutionPlanRuntime> executionPlanRuntimeMap;
    private MemoryUsageTracker memoryUsageTracker;
    private SiddhiDebugger siddhiDebugger;

    public ExecutionPlanRuntime(ConcurrentMap<String, AbstractDefinition> streamDefinitionMap, ConcurrentMap<String, AbstractDefinition> tableDefinitionMap, InputManager inputManager, ConcurrentMap<String, QueryRuntime> queryProcessorMap, ConcurrentMap<String, StreamJunction> streamJunctionMap, ConcurrentMap<String, EventTable> eventTableMap, ConcurrentMap<String, PartitionRuntime> partitionMap, ExecutionPlanContext executionPlanContext, ConcurrentMap<String, ExecutionPlanRuntime> executionPlanRuntimeMap) {
        this.streamDefinitionMap = streamDefinitionMap;
        this.tableDefinitionMap = tableDefinitionMap;
        this.inputManager = inputManager;
        this.queryProcessorMap = queryProcessorMap;
        this.streamJunctionMap = streamJunctionMap;
        this.eventTableMap = eventTableMap;
        this.partitionMap = partitionMap;
        this.executionPlanContext = executionPlanContext;
        this.executionPlanRuntimeMap = executionPlanRuntimeMap;
        if (executionPlanContext.isStatsEnabled() && executionPlanContext.getStatisticsManager() != null) {
            this.memoryUsageTracker = executionPlanContext.getSiddhiContext().getStatisticsConfiguration().getFactory().createMemoryUsageTracker(executionPlanContext.getStatisticsManager());
            this.monitorQueryMemoryUsage();
        }
        this.siddhiDebugger = new SiddhiDebugger(executionPlanContext);
    }

    public String getName() {
        return this.executionPlanContext.getName();
    }

    public Map<String, AbstractDefinition> getStreamDefinitionMap() {
        return this.streamDefinitionMap;
    }

    public void addCallback(String streamId, StreamCallback streamCallback) {
        streamCallback.setStreamId(streamId);
        StreamJunction streamJunction = (StreamJunction)this.streamJunctionMap.get(streamId);
        if (streamJunction == null) {
            throw new DefinitionNotExistException("No stream found with name: " + streamId);
        }
        streamCallback.setStreamDefinition((AbstractDefinition)this.streamDefinitionMap.get(streamId));
        streamCallback.setContext(this.executionPlanContext);
        streamJunction.subscribe(streamCallback);
    }

    public void addCallback(String queryName, QueryCallback callback) {
        callback.setContext(this.executionPlanContext);
        QueryRuntime queryRuntime = (QueryRuntime)this.queryProcessorMap.get(queryName);
        if (queryRuntime == null) {
            throw new QueryNotExistException("No query found with name: " + queryName);
        }
        callback.setQuery(queryRuntime.getQuery());
        queryRuntime.addCallback(callback);
    }

    public InputHandler getInputHandler(String streamId) {
        return this.inputManager.getInputHandler(streamId);
    }

    public synchronized void shutdown() {
        for (EternalReferencedHolder eternalReferencedHolder : this.executionPlanContext.getEternalReferencedHolders()) {
            try {
                eternalReferencedHolder.stop();
            }
            catch (Throwable t) {
                log.error((Object)("Error in shutting down Execution Plan '" + this.executionPlanContext.getName() + "', " + t.getMessage()), t);
            }
        }
        this.inputManager.disconnect();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                for (StreamJunction streamJunction : ExecutionPlanRuntime.this.streamJunctionMap.values()) {
                    streamJunction.stopProcessing();
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ExecutionPlanRuntime.this.executionPlanContext.getScheduledExecutorService().shutdownNow();
                ExecutionPlanRuntime.this.executionPlanContext.getExecutorService().shutdownNow();
            }
        }, "Siddhi-ExecutionPlan-" + this.executionPlanContext.getName() + "-Shutdown-Cleaner");
        thread.start();
        if (this.executionPlanRuntimeMap != null) {
            this.executionPlanRuntimeMap.remove(this.executionPlanContext.getName());
        }
        if (this.executionPlanContext.isStatsEnabled() && this.executionPlanContext.getStatisticsManager() != null) {
            this.executionPlanContext.getStatisticsManager().stopReporting();
            this.executionPlanContext.getStatisticsManager().cleanup();
        }
    }

    public synchronized void start() {
        if (this.executionPlanContext.isStatsEnabled() && this.executionPlanContext.getStatisticsManager() != null) {
            this.executionPlanContext.getStatisticsManager().startReporting();
        }
        for (EternalReferencedHolder eternalReferencedHolder : this.executionPlanContext.getEternalReferencedHolders()) {
            eternalReferencedHolder.start();
        }
        for (StreamJunction streamJunction : this.streamJunctionMap.values()) {
            streamJunction.startProcessing();
        }
    }

    public synchronized SiddhiDebugger debug() {
        ArrayList<StreamRuntime> streamRuntime = new ArrayList<StreamRuntime>();
        ArrayList<OutputCallback> outputCallbacks = new ArrayList<OutputCallback>();
        for (QueryRuntime queryRuntime : this.queryProcessorMap.values()) {
            streamRuntime.add(queryRuntime.getStreamRuntime());
            outputCallbacks.add(queryRuntime.getOutputCallback());
        }
        for (StreamRuntime streamRuntime1 : streamRuntime) {
            for (SingleStreamRuntime singleStreamRuntime : streamRuntime1.getSingleStreamRuntimes()) {
                singleStreamRuntime.getProcessStreamReceiver().setSiddhiDebugger(this.siddhiDebugger);
            }
        }
        for (OutputCallback callback : outputCallbacks) {
            callback.setDebugger(this.siddhiDebugger);
        }
        this.start();
        return this.siddhiDebugger;
    }

    public String persist() {
        return this.executionPlanContext.getPersistenceService().persist();
    }

    public void restoreRevision(String revision) {
        this.executionPlanContext.getPersistenceService().restoreRevision(revision);
    }

    public void restoreLastRevision() {
        this.executionPlanContext.getPersistenceService().restoreLastRevision();
    }

    public byte[] snapshot() {
        return this.executionPlanContext.getSnapshotService().snapshot();
    }

    public void restore(byte[] snapshot) {
        this.executionPlanContext.getSnapshotService().restore(snapshot);
    }

    private void monitorQueryMemoryUsage() {
        for (Map.Entry entry : this.queryProcessorMap.entrySet()) {
            this.memoryUsageTracker.registerObject(entry.getValue(), this.executionPlanContext.getSiddhiContext().getStatisticsConfiguration().getMatricPrefix() + "." + "ExecutionPlans" + "." + this.getName() + "." + "Siddhi" + "." + "Queries" + "." + entry.getKey());
        }
        for (Map.Entry entry : this.partitionMap.entrySet()) {
            ConcurrentMap<String, QueryRuntime> queryRuntime = ((PartitionRuntime)entry.getValue()).getMetaQueryRuntimeMap();
            for (Map.Entry query : queryRuntime.entrySet()) {
                this.memoryUsageTracker.registerObject(entry.getValue(), this.executionPlanContext.getSiddhiContext().getStatisticsConfiguration().getMatricPrefix() + "." + "ExecutionPlans" + "." + this.getName() + "." + "Siddhi" + "." + "Queries" + "." + query.getKey());
            }
        }
    }

    public void handleExceptionWith(ExceptionHandler<Object> exceptionHandler) {
        this.executionPlanContext.setDisruptorExceptionHandler(exceptionHandler);
    }
}

