/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.snapshot;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.SnapshotableElementsHolder;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.debugger.QueryState;
import org.wso2.siddhi.core.util.persistence.PersistenceStore;
import org.wso2.siddhi.core.util.snapshot.ByteSerializer;
import org.wso2.siddhi.core.util.snapshot.Snapshotable;
import org.wso2.siddhi.core.util.snapshot.SnapshotableElement;

public class SnapshotService {
    private HashMap<String, List<Snapshotable>> snapshotableMap = new HashMap();
    private static final Logger LOGGER = Logger.getLogger(SnapshotService.class);
    private static final String SNAPSHOTABLE_STATES_KEY = "snapshotable.states";
    private static final SnapshotableElementsHolder snapshotableElementsHolder = new SnapshotableElementsHolder();
    private ExecutionPlanContext executionPlanContext;
    private static PersistenceStore persistenceStore;

    public SnapshotService(ExecutionPlanContext executionPlanContext) {
        this.executionPlanContext = executionPlanContext;
    }

    public static void persistSnapshotableElements() {
        if (persistenceStore != null) {
            HashMap<String, Map<String, Object>> snapshots = new HashMap<String, Map<String, Object>>(snapshotableElementsHolder.getSnapshotableElements().size());
            LOGGER.debug((Object)"Taking snapshots of snapshotable elements...");
            try {
                for (SnapshotableElement snapshotable : snapshotableElementsHolder.getSnapshotableElements()) {
                    snapshotable.freeze();
                    snapshots.put(snapshotable.getElementId(), snapshotable.currentState());
                }
                byte[] serializedSnapshots = ByteSerializer.OToB(snapshots);
                LOGGER.debug((Object)"Finished taking snapshots of snapshotable elements.");
                persistenceStore.save(SNAPSHOTABLE_STATES_KEY, String.valueOf(System.currentTimeMillis()), serializedSnapshots);
                SnapshotService.nofityReceiversOnSave(serializedSnapshots);
            }
            finally {
                for (SnapshotableElement snapshotable : snapshotableElementsHolder.getSnapshotableElements()) {
                    snapshotable.unfreeze();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restoreSnapshotableElements() {
        String revision;
        if (persistenceStore != null && (revision = persistenceStore.getLastRevision(SNAPSHOTABLE_STATES_KEY)) != null) {
            byte[] snapshot;
            HashMap snapshots;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Restoring snapshotable elements revision: " + revision + " ..."));
            }
            if ((snapshots = (HashMap)ByteSerializer.BToO(snapshot = persistenceStore.load(SNAPSHOTABLE_STATES_KEY, revision))) != null) {
                for (Map.Entry entry : snapshots.entrySet()) {
                    String elementName = (String)entry.getKey();
                    Map savedState = (Map)entry.getValue();
                    SnapshotableElement snapshotable = snapshotableElementsHolder.getSnapshotableElement(elementName);
                    if (snapshotable == null) {
                        SnapshotableElementsHolder.putExistingState(elementName, savedState);
                        continue;
                    }
                    try {
                        snapshotable.freeze();
                        snapshotable.restoreState(savedState);
                    }
                    finally {
                        snapshotable.unfreeze();
                    }
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Restored snapshotable elements revision: " + revision));
                }
            }
        }
    }

    private static void nofityReceiversOnSave(byte[] snapshot) {
        HashMap snapshots = (HashMap)ByteSerializer.BToO(snapshot);
        for (SnapshotableElement snapshotable : snapshotableElementsHolder.getSnapshotableElements()) {
            if (snapshots == null || snapshots.get(snapshotable.getElementId()) == null) continue;
            snapshotable.onSave((Map)snapshots.get(snapshotable.getElementId()));
        }
    }

    public synchronized void addSnapshotable(String queryName, Snapshotable snapshotable) {
        List<Snapshotable> snapshotableList = this.snapshotableMap.get(queryName);
        if (snapshotableList == null) {
            snapshotableList = new ArrayList<Snapshotable>();
            snapshotableList.add(snapshotable);
            this.snapshotableMap.put(queryName, snapshotableList);
        } else if (!snapshotableList.contains(snapshotable)) {
            snapshotableList.add(snapshotable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] snapshot() {
        HashMap<String, Object[]> snapshots = new HashMap<String, Object[]>(this.snapshotableMap.size());
        List<Object> snapshotableList = new ArrayList();
        LOGGER.debug((Object)"Taking snapshot ...");
        try {
            this.executionPlanContext.getThreadBarrier().lock();
            for (Map.Entry<String, List<Snapshotable>> entry : this.snapshotableMap.entrySet()) {
                snapshotableList = entry.getValue();
                ArrayList snaps = new ArrayList();
                for (Snapshotable snapshotable : snapshotableList) {
                    snapshots.put(snapshotable.getElementId(), snapshotable.currentState());
                }
            }
        }
        finally {
            this.executionPlanContext.getThreadBarrier().unlock();
        }
        LOGGER.info((Object)("Snapshot taken of Execution Plan '" + this.executionPlanContext.getName() + "'"));
        LOGGER.debug((Object)"Snapshot serialization started ...");
        byte[] serializedSnapshots = ByteSerializer.OToB(snapshots);
        LOGGER.debug((Object)"Snapshot serialization finished.");
        return serializedSnapshots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryState queryState(String queryName) {
        QueryState queryState = new QueryState();
        try {
            this.executionPlanContext.getThreadBarrier().lock();
            List<Snapshotable> list = this.snapshotableMap.get(queryName);
            if (list != null) {
                for (Snapshotable element : list) {
                    HashMap subMap = new HashMap();
                    ArrayList<Object> unknownFieldList = new ArrayList<Object>();
                    Object[] currentState = element.currentState();
                    String elementId = element.getElementId();
                    for (Object state : currentState) {
                        if (state instanceof Map.Entry) {
                            subMap.put((String)((Map.Entry)state).getKey(), ((Map.Entry)state).getValue());
                            continue;
                        }
                        unknownFieldList.add(state);
                    }
                    if (subMap.size() != 0) {
                        queryState.addKnownFields(new AbstractMap.SimpleEntry<String, Map<String, Object>>(elementId, subMap));
                    }
                    if (unknownFieldList.size() == 0) continue;
                    queryState.addUnknownFields(new AbstractMap.SimpleEntry<String, Object[]>(elementId, unknownFieldList.toArray()));
                }
            }
        }
        finally {
            this.executionPlanContext.getThreadBarrier().unlock();
        }
        LOGGER.debug((Object)"Taking snapshot finished.");
        return queryState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore(byte[] snapshot) {
        HashMap snapshots = (HashMap)ByteSerializer.BToO(snapshot);
        try {
            this.executionPlanContext.getThreadBarrier().lock();
            for (Map.Entry<String, List<Snapshotable>> entry : this.snapshotableMap.entrySet()) {
                List<Snapshotable> snapshotableList = entry.getValue();
                for (Snapshotable snapshotable : snapshotableList) {
                    if (snapshots == null) continue;
                    snapshotable.restoreState((Object[])snapshots.get(snapshotable.getElementId()));
                }
            }
        }
        finally {
            this.executionPlanContext.getThreadBarrier().unlock();
        }
    }

    public static void setPersistenceStore(PersistenceStore persistenceStore) {
        SnapshotService.persistenceStore = persistenceStore;
    }
}

