/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.parser;

import java.util.List;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.event.stream.converter.ZeroStreamEventConverter;
import org.wso2.siddhi.core.exception.OperationNotSupportedException;
import org.wso2.siddhi.core.table.holder.EventHolder;
import org.wso2.siddhi.core.table.holder.ListEventHolder;
import org.wso2.siddhi.core.table.holder.PrimaryKeyEventHolder;
import org.wso2.siddhi.query.api.annotation.Annotation;
import org.wso2.siddhi.query.api.annotation.Element;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;
import org.wso2.siddhi.query.api.util.AnnotationHelper;

public class EventHolderPasser {
    public static EventHolder parse(AbstractDefinition tableDefinition, StreamEventPool tableStreamEventPool) {
        ZeroStreamEventConverter eventConverter = new ZeroStreamEventConverter();
        Annotation indexByAnnotation = AnnotationHelper.getAnnotation((String)"IndexBy", (List)tableDefinition.getAnnotations());
        if (indexByAnnotation != null) {
            if (indexByAnnotation.getElements().size() > 1) {
                throw new OperationNotSupportedException("IndexBy annotation contains " + indexByAnnotation.getElements().size() + " elements, Siddhi in-memory table only supports indexing based on a single attribute");
            }
            if (indexByAnnotation.getElements().size() == 0) {
                throw new ExecutionPlanValidationException("IndexBy annotation contains " + indexByAnnotation.getElements().size() + " element");
            }
            String indexAttribute = ((Element)indexByAnnotation.getElements().get(0)).getValue();
            int indexPosition = tableDefinition.getAttributePosition(indexAttribute);
            return new PrimaryKeyEventHolder(tableStreamEventPool, eventConverter, indexPosition, indexAttribute);
        }
        return new ListEventHolder(tableStreamEventPool, eventConverter);
    }
}

