/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.selector;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.GroupedComplexEvent;
import org.wso2.siddhi.core.event.state.populater.StateEventPopulator;
import org.wso2.siddhi.core.exception.ExecutionPlanCreationException;
import org.wso2.siddhi.core.executor.condition.ConditionExpressionExecutor;
import org.wso2.siddhi.core.query.output.ratelimit.OutputRateLimiter;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.selector.GroupByKeyGenerator;
import org.wso2.siddhi.core.query.selector.attribute.processor.AttributeProcessor;
import org.wso2.siddhi.query.api.execution.query.selection.Selector;

public class QuerySelector
implements Processor {
    private static final Logger log = Logger.getLogger(QuerySelector.class);
    private static final ThreadLocal<String> keyThreadLocal = new ThreadLocal();
    private Selector selector;
    private ExecutionPlanContext executionPlanContext;
    private boolean currentOn = false;
    private boolean expiredOn = false;
    private boolean containsAggregator = false;
    private OutputRateLimiter outputRateLimiter;
    private List<AttributeProcessor> attributeProcessorList;
    private ConditionExpressionExecutor havingConditionExecutor = null;
    private boolean isGroupBy = false;
    private GroupByKeyGenerator groupByKeyGenerator;
    private String id;
    private StateEventPopulator eventPopulator;
    private boolean batchingEnabled = true;

    public QuerySelector(String id, Selector selector, boolean currentOn, boolean expiredOn, ExecutionPlanContext executionPlanContext) {
        this.id = id;
        this.currentOn = currentOn;
        this.expiredOn = expiredOn;
        this.selector = selector;
        this.executionPlanContext = executionPlanContext;
    }

    public static String getThreadLocalGroupByKey() {
        return keyThreadLocal.get();
    }

    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("event is processed by selector " + this.id + this));
        }
        if (this.containsAggregator && complexEventChunk.isBatch() && this.batchingEnabled) {
            if (this.isGroupBy) {
                this.processInBatchGroupBy(complexEventChunk);
            } else {
                this.processInBatchNoGroupBy(complexEventChunk);
            }
        } else if (this.isGroupBy) {
            this.processGroupBy(complexEventChunk);
        } else {
            this.processNoGroupBy(complexEventChunk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNoGroupBy(ComplexEventChunk complexEventChunk) {
        complexEventChunk.reset();
        QuerySelector querySelector = this;
        synchronized (querySelector) {
            while (complexEventChunk.hasNext()) {
                Object event = complexEventChunk.next();
                switch (event.getType()) {
                    case CURRENT: 
                    case EXPIRED: {
                        this.eventPopulator.populateStateEvent((ComplexEvent)event);
                        for (AttributeProcessor attributeProcessor : this.attributeProcessorList) {
                            attributeProcessor.process((ComplexEvent)event);
                        }
                        if ((event.getType() == ComplexEvent.Type.CURRENT && this.currentOn || event.getType() == ComplexEvent.Type.EXPIRED && this.expiredOn) && (this.havingConditionExecutor == null || this.havingConditionExecutor.execute((ComplexEvent)event).booleanValue())) break;
                        complexEventChunk.remove();
                        break;
                    }
                    case RESET: {
                        for (AttributeProcessor attributeProcessor : this.attributeProcessorList) {
                            attributeProcessor.process((ComplexEvent)event);
                        }
                    }
                    case TIMER: {
                        complexEventChunk.remove();
                    }
                }
            }
        }
        complexEventChunk.reset();
        if (complexEventChunk.hasNext()) {
            this.outputRateLimiter.process(complexEventChunk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGroupBy(ComplexEventChunk complexEventChunk) {
        complexEventChunk.reset();
        ComplexEventChunk<GroupedComplexEvent> currentComplexEventChunk = new ComplexEventChunk<GroupedComplexEvent>(complexEventChunk.isBatch());
        QuerySelector querySelector = this;
        synchronized (querySelector) {
            while (complexEventChunk.hasNext()) {
                Object event = complexEventChunk.next();
                switch (event.getType()) {
                    case CURRENT: 
                    case EXPIRED: {
                        this.eventPopulator.populateStateEvent((ComplexEvent)event);
                        String groupedByKey = this.groupByKeyGenerator.constructEventKey((ComplexEvent)event);
                        keyThreadLocal.set(groupedByKey);
                        for (AttributeProcessor attributeProcessor : this.attributeProcessorList) {
                            attributeProcessor.process((ComplexEvent)event);
                        }
                        if ((event.getType() == ComplexEvent.Type.CURRENT && this.currentOn || event.getType() == ComplexEvent.Type.EXPIRED && this.expiredOn) && (this.havingConditionExecutor == null || this.havingConditionExecutor.execute((ComplexEvent)event).booleanValue())) {
                            complexEventChunk.remove();
                            currentComplexEventChunk.add(new GroupedComplexEvent(groupedByKey, (ComplexEvent)event));
                        }
                        keyThreadLocal.remove();
                        break;
                    }
                    case TIMER: {
                        break;
                    }
                    case RESET: {
                        for (AttributeProcessor attributeProcessor : this.attributeProcessorList) {
                            attributeProcessor.process((ComplexEvent)event);
                        }
                        break;
                    }
                }
            }
        }
        currentComplexEventChunk.reset();
        if (currentComplexEventChunk.hasNext()) {
            this.outputRateLimiter.process(currentComplexEventChunk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInBatchNoGroupBy(ComplexEventChunk complexEventChunk) {
        complexEventChunk.reset();
        Object lastEvent = null;
        QuerySelector querySelector = this;
        synchronized (querySelector) {
            while (complexEventChunk.hasNext()) {
                Object event = complexEventChunk.next();
                switch (event.getType()) {
                    case CURRENT: 
                    case EXPIRED: {
                        this.eventPopulator.populateStateEvent((ComplexEvent)event);
                        for (AttributeProcessor attributeProcessor : this.attributeProcessorList) {
                            attributeProcessor.process((ComplexEvent)event);
                        }
                        if (this.havingConditionExecutor != null && !this.havingConditionExecutor.execute((ComplexEvent)event).booleanValue() || (event.getType() != ComplexEvent.Type.CURRENT || !this.currentOn) && (event.getType() != ComplexEvent.Type.EXPIRED || !this.expiredOn)) break;
                        complexEventChunk.remove();
                        lastEvent = event;
                        break;
                    }
                    case TIMER: {
                        break;
                    }
                    case RESET: {
                        for (AttributeProcessor attributeProcessor : this.attributeProcessorList) {
                            attributeProcessor.process((ComplexEvent)event);
                        }
                        break;
                    }
                }
            }
        }
        if (lastEvent != null) {
            complexEventChunk.clear();
            complexEventChunk.add(lastEvent);
            this.outputRateLimiter.process(complexEventChunk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInBatchGroupBy(ComplexEventChunk complexEventChunk) {
        LinkedHashMap<String, Object> groupedEvents = new LinkedHashMap<String, Object>();
        complexEventChunk.reset();
        QuerySelector querySelector = this;
        synchronized (querySelector) {
            while (complexEventChunk.hasNext()) {
                Object object = complexEventChunk.next();
                switch (object.getType()) {
                    case CURRENT: 
                    case EXPIRED: {
                        this.eventPopulator.populateStateEvent((ComplexEvent)object);
                        String groupByKey = this.groupByKeyGenerator.constructEventKey((ComplexEvent)object);
                        keyThreadLocal.set(groupByKey);
                        for (AttributeProcessor attributeProcessor : this.attributeProcessorList) {
                            attributeProcessor.process((ComplexEvent)object);
                        }
                        if ((this.havingConditionExecutor == null || this.havingConditionExecutor.execute((ComplexEvent)object).booleanValue()) && (object.getType() == ComplexEvent.Type.CURRENT && this.currentOn || object.getType() == ComplexEvent.Type.EXPIRED && this.expiredOn)) {
                            complexEventChunk.remove();
                            groupedEvents.put(groupByKey, object);
                        }
                        keyThreadLocal.remove();
                        break;
                    }
                    case TIMER: {
                        break;
                    }
                    case RESET: {
                        for (AttributeProcessor attributeProcessor : this.attributeProcessorList) {
                            attributeProcessor.process((ComplexEvent)object);
                        }
                        break;
                    }
                }
            }
        }
        if (groupedEvents.size() != 0) {
            complexEventChunk.clear();
            for (Map.Entry entry : groupedEvents.entrySet()) {
                complexEventChunk.add(new GroupedComplexEvent((String)entry.getKey(), (ComplexEvent)entry.getValue()));
            }
            complexEventChunk.reset();
            this.outputRateLimiter.process(complexEventChunk);
        }
    }

    @Override
    public Processor getNextProcessor() {
        return null;
    }

    public void setNextProcessor(OutputRateLimiter outputRateLimiter) {
        if (this.outputRateLimiter != null) {
            throw new ExecutionPlanCreationException("outputRateLimiter is already assigned");
        }
        this.outputRateLimiter = outputRateLimiter;
    }

    @Override
    public void setNextProcessor(Processor processor) {
    }

    @Override
    public void setToLast(Processor processor) {
        if (this.getNextProcessor() == null) {
            this.setNextProcessor(processor);
        } else {
            this.getNextProcessor().setToLast(processor);
        }
    }

    @Override
    public Processor cloneProcessor(String key) {
        return null;
    }

    public List<AttributeProcessor> getAttributeProcessorList() {
        return this.attributeProcessorList;
    }

    public void setAttributeProcessorList(List<AttributeProcessor> attributeProcessorList, boolean containsAggregator) {
        this.attributeProcessorList = attributeProcessorList;
        this.containsAggregator = this.containsAggregator || containsAggregator;
    }

    public void setGroupByKeyGenerator(GroupByKeyGenerator groupByKeyGenerator) {
        this.isGroupBy = true;
        this.groupByKeyGenerator = groupByKeyGenerator;
    }

    public void setHavingConditionExecutor(ConditionExpressionExecutor havingConditionExecutor, boolean containsAggregator) {
        this.havingConditionExecutor = havingConditionExecutor;
        this.containsAggregator = this.containsAggregator || containsAggregator;
    }

    public QuerySelector clone(String key) {
        QuerySelector clonedQuerySelector = new QuerySelector(this.id + key, this.selector, this.currentOn, this.expiredOn, this.executionPlanContext);
        ArrayList<AttributeProcessor> clonedAttributeProcessorList = new ArrayList<AttributeProcessor>();
        for (AttributeProcessor attributeProcessor : this.attributeProcessorList) {
            clonedAttributeProcessorList.add(attributeProcessor.cloneProcessor(key));
        }
        clonedQuerySelector.attributeProcessorList = clonedAttributeProcessorList;
        clonedQuerySelector.isGroupBy = this.isGroupBy;
        clonedQuerySelector.containsAggregator = this.containsAggregator;
        clonedQuerySelector.groupByKeyGenerator = this.groupByKeyGenerator;
        clonedQuerySelector.havingConditionExecutor = this.havingConditionExecutor;
        clonedQuerySelector.eventPopulator = this.eventPopulator;
        clonedQuerySelector.batchingEnabled = this.batchingEnabled;
        return clonedQuerySelector;
    }

    public void setBatchingEnabled(boolean batchingEnabled) {
        this.batchingEnabled = batchingEnabled;
    }

    public void setEventPopulator(StateEventPopulator eventPopulator) {
        this.eventPopulator = eventPopulator;
    }
}

