/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.output.ratelimit.event;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.query.output.ratelimit.OutputRateLimiter;

public class LastPerEventOutputRateLimiter
extends OutputRateLimiter {
    private final Integer value;
    private String id;
    private volatile int counter = 0;

    public LastPerEventOutputRateLimiter(String id, Integer value) {
        this.id = id;
        this.value = value;
    }

    @Override
    public OutputRateLimiter clone(String key) {
        LastPerEventOutputRateLimiter instance = new LastPerEventOutputRateLimiter(this.id + key, this.value);
        instance.setLatencyTracker(this.latencyTracker);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        complexEventChunk.reset();
        ArrayList outputEventChunks = new ArrayList();
        LastPerEventOutputRateLimiter lastPerEventOutputRateLimiter = this;
        synchronized (lastPerEventOutputRateLimiter) {
            while (complexEventChunk.hasNext()) {
                Object object = complexEventChunk.next();
                if (object.getType() != ComplexEvent.Type.CURRENT && object.getType() != ComplexEvent.Type.EXPIRED || ++this.counter != this.value) continue;
                complexEventChunk.remove();
                ComplexEventChunk<Object> lastPerEventChunk = new ComplexEventChunk<Object>(complexEventChunk.isBatch());
                lastPerEventChunk.add(object);
                this.counter = 0;
                outputEventChunks.add(lastPerEventChunk);
            }
        }
        for (ComplexEventChunk complexEventChunk2 : outputEventChunks) {
            this.sendToCallBacks(complexEventChunk2);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Object[] currentState() {
        return new Object[]{new AbstractMap.SimpleEntry<String, Integer>("Counter", this.counter)};
    }

    @Override
    public void restoreState(Object[] state) {
        Map.Entry stateEntry = (Map.Entry)state[0];
        this.counter = (Integer)stateEntry.getValue();
    }
}

