/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.output.callback;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.query.api.execution.query.Query;

public abstract class QueryCallback {
    private static final Logger log = Logger.getLogger(QueryCallback.class);
    private ExecutionPlanContext executionPlanContext;
    private Query query;

    public void setQuery(Query query) {
        this.query = query;
    }

    public void setContext(ExecutionPlanContext executionPlanContext) {
        this.executionPlanContext = executionPlanContext;
    }

    public void receiveStreamEvent(ComplexEventChunk complexEventChunk) {
        Event[] currentEvents = null;
        Event[] expiredEvents = null;
        long timeStamp = -1L;
        ArrayList<Event> currentEventBuffer = new ArrayList<Event>();
        ArrayList<Event> expiredEventBuffer = new ArrayList<Event>();
        complexEventChunk.reset();
        while (complexEventChunk.hasNext()) {
            Object streamEvent = complexEventChunk.next();
            if (streamEvent.getType() == ComplexEvent.Type.EXPIRED) {
                this.bufferEvent((ComplexEvent)streamEvent, expiredEventBuffer);
            } else if (streamEvent.getType() == ComplexEvent.Type.CURRENT) {
                this.bufferEvent((ComplexEvent)streamEvent, currentEventBuffer);
            }
            timeStamp = streamEvent.getTimestamp();
        }
        if (!currentEventBuffer.isEmpty()) {
            currentEvents = currentEventBuffer.toArray(new Event[currentEventBuffer.size()]);
            currentEventBuffer.clear();
        }
        if (!expiredEventBuffer.isEmpty()) {
            expiredEvents = expiredEventBuffer.toArray(new Event[expiredEventBuffer.size()]);
            expiredEventBuffer.clear();
        }
        this.send(timeStamp, currentEvents, expiredEvents);
    }

    private void send(long timeStamp, Event[] currentEvents, Event[] expiredEvents) {
        try {
            this.receive(timeStamp, currentEvents, expiredEvents);
        }
        catch (RuntimeException e) {
            log.error((Object)("Error on sending events" + Arrays.deepToString(currentEvents) + ", " + Arrays.deepToString(expiredEvents)), (Throwable)e);
        }
    }

    private void bufferEvent(ComplexEvent complexEvent, List<Event> eventBuffer) {
        eventBuffer.add(new Event(complexEvent.getOutputData().length).copyFrom(complexEvent));
    }

    public synchronized void startProcessing() {
    }

    public synchronized void stopProcessing() {
    }

    public abstract void receive(long var1, Event[] var3, Event[] var4);
}

