/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.output.callback;

import org.wso2.siddhi.core.debugger.SiddhiDebugger;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.state.StateEventPool;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.event.stream.converter.StreamEventConverter;
import org.wso2.siddhi.core.query.output.callback.OutputCallback;
import org.wso2.siddhi.core.table.EventTable;
import org.wso2.siddhi.core.util.collection.OverwritingStreamEventExtractor;
import org.wso2.siddhi.core.util.collection.UpdateAttributeMapper;
import org.wso2.siddhi.core.util.collection.operator.Operator;
import org.wso2.siddhi.core.util.parser.MatcherParser;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;

public class InsertOverwriteTableCallback
extends OutputCallback {
    private final int matchingStreamIndex;
    private final UpdateAttributeMapper[] updateAttributeMappers;
    private final OverwritingStreamEventExtractor overwritingStreamEventExtractor;
    private EventTable eventTable;
    private Operator operator;
    private boolean convertToStreamEvent;
    private StateEventPool stateEventPool;
    private StreamEventPool streamEventPool;
    private StreamEventConverter streamEventConverter;

    public InsertOverwriteTableCallback(EventTable eventTable, Operator operator, AbstractDefinition updatingStreamDefinition, int matchingStreamIndex, boolean convertToStreamEvent, StateEventPool stateEventPool, StreamEventPool streamEventPool, StreamEventConverter streamEventConverter, String queryName) {
        super(queryName);
        this.matchingStreamIndex = matchingStreamIndex;
        this.eventTable = eventTable;
        this.operator = operator;
        this.convertToStreamEvent = convertToStreamEvent;
        this.stateEventPool = stateEventPool;
        this.streamEventPool = streamEventPool;
        this.streamEventConverter = streamEventConverter;
        this.updateAttributeMappers = MatcherParser.constructUpdateAttributeMapper((AbstractDefinition)eventTable.getTableDefinition(), updatingStreamDefinition.getAttributeList(), matchingStreamIndex);
        this.overwritingStreamEventExtractor = new OverwritingStreamEventExtractor(matchingStreamIndex);
    }

    @Override
    public void send(ComplexEventChunk overwriteOrAddEventChunk) {
        if (this.getDebugger() != null) {
            this.getDebugger().checkBreakPoint(this.getQueryName(), SiddhiDebugger.QueryTerminal.OUT, (ComplexEvent)overwriteOrAddEventChunk.getFirst());
        }
        overwriteOrAddEventChunk.reset();
        if (overwriteOrAddEventChunk.hasNext()) {
            ComplexEventChunk<StateEvent> overwriteOrAddStateEventChunk = this.constructMatchingStateEventChunk(overwriteOrAddEventChunk, this.convertToStreamEvent, this.stateEventPool, this.matchingStreamIndex, this.streamEventPool, this.streamEventConverter);
            this.constructMatchingStateEventChunk(overwriteOrAddEventChunk, this.convertToStreamEvent, this.stateEventPool, this.matchingStreamIndex, this.streamEventPool, this.streamEventConverter);
            this.eventTable.overwriteOrAdd(overwriteOrAddStateEventChunk, this.operator, this.updateAttributeMappers, this.overwritingStreamEventExtractor);
        }
    }
}

