/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.executor.function;

import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.executor.ConstantExpressionExecutor;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

public class ConvertFunctionExecutor
extends FunctionExecutor {
    private Attribute.Type returnType;
    private Attribute.Type inputType;

    @Override
    public void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors.length != 2) {
            throw new ExecutionPlanValidationException("convert() must have at 2 parameters, attribute and to be converted type");
        }
        this.inputType = attributeExpressionExecutors[0].getReturnType();
        if (this.inputType == Attribute.Type.OBJECT) {
            throw new ExecutionPlanValidationException("1st parameter of convert() cannot be 'object' as it's not supported, it has to be either of (STRING, INT, LONG, FLOAT, DOUBLE, BOOL), but found " + attributeExpressionExecutors[0].getReturnType());
        }
        if (attributeExpressionExecutors[1].getReturnType() != Attribute.Type.STRING) {
            throw new ExecutionPlanValidationException("2nd parameter of convert() must be 'string' have constant value either of (STRING, INT, LONG, FLOAT, DOUBLE, BOOL), but found " + attributeExpressionExecutors[0].getReturnType());
        }
        if (!(attributeExpressionExecutors[1] instanceof ConstantExpressionExecutor)) {
            throw new ExecutionPlanValidationException("2nd parameter of convert() must have constant value either of (STRING, INT, LONG, FLOAT, DOUBLE, BOOL), but found a variable expression");
        }
        String type = (String)attributeExpressionExecutors[1].execute(null);
        if (Attribute.Type.STRING.toString().equalsIgnoreCase(type)) {
            this.returnType = Attribute.Type.STRING;
        } else if (Attribute.Type.BOOL.toString().equalsIgnoreCase(type)) {
            this.returnType = Attribute.Type.BOOL;
        } else if (Attribute.Type.DOUBLE.toString().equalsIgnoreCase(type)) {
            this.returnType = Attribute.Type.DOUBLE;
        } else if (Attribute.Type.FLOAT.toString().equalsIgnoreCase(type)) {
            this.returnType = Attribute.Type.FLOAT;
        } else if (Attribute.Type.INT.toString().equalsIgnoreCase(type)) {
            this.returnType = Attribute.Type.INT;
        } else if (Attribute.Type.LONG.toString().equalsIgnoreCase(type)) {
            this.returnType = Attribute.Type.LONG;
        } else {
            throw new ExecutionPlanValidationException("2nd parameter of convert() must have value either of (STRING, INT, LONG, FLOAT, DOUBLE, BOOL), but found '" + type + "'");
        }
    }

    @Override
    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    @Override
    protected Object execute(Object[] obj) {
        Object data = obj[0];
        if (data != null) {
            try {
                switch (this.returnType) {
                    case STRING: {
                        return data.toString();
                    }
                    case INT: {
                        switch (this.inputType) {
                            case STRING: {
                                return Integer.parseInt((String)data);
                            }
                            case INT: {
                                return data;
                            }
                            case LONG: {
                                return ((Long)data).intValue();
                            }
                            case FLOAT: {
                                return ((Float)data).intValue();
                            }
                            case DOUBLE: {
                                return ((Double)data).intValue();
                            }
                            case BOOL: {
                                return (Boolean)data != false ? 1 : 0;
                            }
                            case OBJECT: {
                                return null;
                            }
                        }
                        break;
                    }
                    case LONG: {
                        switch (this.inputType) {
                            case STRING: {
                                return Long.parseLong((String)data);
                            }
                            case INT: {
                                return ((Integer)data).longValue();
                            }
                            case LONG: {
                                return data;
                            }
                            case FLOAT: {
                                return ((Float)data).longValue();
                            }
                            case DOUBLE: {
                                return ((Double)data).longValue();
                            }
                            case BOOL: {
                                return (Boolean)data != false ? 1L : 0L;
                            }
                            case OBJECT: {
                                return null;
                            }
                        }
                        break;
                    }
                    case FLOAT: {
                        switch (this.inputType) {
                            case STRING: {
                                return Float.valueOf(Float.parseFloat((String)data));
                            }
                            case INT: {
                                return Float.valueOf(((Integer)data).floatValue());
                            }
                            case LONG: {
                                return Float.valueOf(((Long)data).floatValue());
                            }
                            case FLOAT: {
                                return data;
                            }
                            case DOUBLE: {
                                return Float.valueOf(((Double)data).floatValue());
                            }
                            case BOOL: {
                                return Float.valueOf((Boolean)data != false ? 1.0f : 0.0f);
                            }
                            case OBJECT: {
                                return null;
                            }
                        }
                        break;
                    }
                    case DOUBLE: {
                        switch (this.inputType) {
                            case STRING: {
                                return Double.parseDouble((String)data);
                            }
                            case INT: {
                                return ((Integer)data).doubleValue();
                            }
                            case LONG: {
                                return ((Long)data).doubleValue();
                            }
                            case FLOAT: {
                                return ((Float)data).doubleValue();
                            }
                            case DOUBLE: {
                                return data;
                            }
                            case BOOL: {
                                return (Boolean)data != false ? 1.0 : 0.0;
                            }
                            case OBJECT: {
                                return null;
                            }
                        }
                        break;
                    }
                    case BOOL: {
                        switch (this.inputType) {
                            case STRING: {
                                return Boolean.parseBoolean((String)data);
                            }
                            case INT: {
                                return (Integer)data == 1;
                            }
                            case LONG: {
                                return (Long)data == 1L;
                            }
                            case FLOAT: {
                                return ((Float)data).floatValue() == 1.0f;
                            }
                            case DOUBLE: {
                                return (Double)data == 1.0;
                            }
                            case BOOL: {
                                return data;
                            }
                            case OBJECT: {
                                return null;
                            }
                        }
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    protected Object execute(Object data) {
        return null;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Object[] currentState() {
        return null;
    }

    @Override
    public void restoreState(Object[] state) {
    }
}

