/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.config;

import com.lmax.disruptor.ExceptionHandler;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.config.StatisticsConfiguration;
import org.wso2.siddhi.core.util.SiddhiExtensionLoader;
import org.wso2.siddhi.core.util.extension.holder.AbstractExtensionHolder;
import org.wso2.siddhi.core.util.persistence.PersistenceStore;
import org.wso2.siddhi.core.util.statistics.metrics.SiddhiMetricsFactory;

public class SiddhiContext {
    private static final Logger log = Logger.getLogger(SiddhiContext.class);
    private ExceptionHandler<Object> defaultDisrupterExceptionHandler;
    private Map<String, Class> siddhiExtensions;
    private PersistenceStore persistenceStore = null;
    private ConcurrentHashMap<String, DataSource> siddhiDataSources;
    private StatisticsConfiguration statisticsConfiguration;
    private ConcurrentHashMap<Class, AbstractExtensionHolder> extensionHolderMap;

    public SiddhiContext() {
        this.setSiddhiExtensions(SiddhiExtensionLoader.loadSiddhiExtensions());
        this.siddhiDataSources = new ConcurrentHashMap();
        this.statisticsConfiguration = new StatisticsConfiguration(new SiddhiMetricsFactory());
        this.extensionHolderMap = new ConcurrentHashMap();
        this.defaultDisrupterExceptionHandler = new ExceptionHandler<Object>(){

            public void handleEventException(Throwable throwable, long l, Object event) {
                log.error((Object)("Disruptor encountered an error processing [sequence: " + l + ", event: " + event.toString() + "]"), throwable);
            }

            public void handleOnStartException(Throwable throwable) {
                log.error((Object)"Disruptor encountered an error on start", throwable);
            }

            public void handleOnShutdownException(Throwable throwable) {
                log.error((Object)"Disruptor encountered an error on shutdown", throwable);
            }
        };
    }

    public Map<String, Class> getSiddhiExtensions() {
        return this.siddhiExtensions;
    }

    public void setSiddhiExtensions(Map<String, Class> siddhiExtensions) {
        this.siddhiExtensions = siddhiExtensions;
    }

    public PersistenceStore getPersistenceStore() {
        return this.persistenceStore;
    }

    public void setPersistenceStore(PersistenceStore persistenceStore) {
        this.persistenceStore = persistenceStore;
    }

    public DataSource getSiddhiDataSource(String dataSourceName) {
        if (dataSourceName != null) {
            return this.siddhiDataSources.get(dataSourceName);
        }
        return null;
    }

    public void addSiddhiDataSource(String dataSourceName, DataSource dataSource) {
        this.siddhiDataSources.put(dataSourceName, dataSource);
    }

    public StatisticsConfiguration getStatisticsConfiguration() {
        return this.statisticsConfiguration;
    }

    public void setStatisticsConfiguration(StatisticsConfiguration statisticsConfiguration) {
        this.statisticsConfiguration = statisticsConfiguration;
    }

    public ConcurrentHashMap<Class, AbstractExtensionHolder> getExtensionHolderMap() {
        return this.extensionHolderMap;
    }

    public ExceptionHandler<Object> getDefaultDisrupterExceptionHandler() {
        return this.defaultDisrupterExceptionHandler;
    }
}

